/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.deployers.vfs.spi.structure.modified.SynchVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDeleteVisitor
extends SynchVisitor {
    private VirtualFile originalRoot;
    private String initialPath;

    public UpdateDeleteVisitor(VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot) {
        this(null, attributes, cache, synchAdapter, originalRoot);
    }

    public UpdateDeleteVisitor(VirtualFileFilter filter, VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot) {
        super(filter, attributes, cache, synchAdapter);
        if (originalRoot == null) {
            throw new IllegalArgumentException("Null original root");
        }
        this.originalRoot = originalRoot;
        this.initialPath = originalRoot.getPathName();
        if (!this.initialPath.endsWith("/")) {
            this.initialPath = this.initialPath + "/";
        }
    }

    @Override
    protected void doVisit(VirtualFile file) throws Exception {
        String pathName = file.getPathName();
        String originalPathName = this.initialPath + pathName;
        VirtualFile child = this.originalRoot.getChild(pathName);
        if (child == null) {
            if (this.getSynchAdapter().delete(file)) {
                this.getCache().removeCache(originalPathName);
            }
        } else {
            Long previous = this.getCache().getCacheValue(originalPathName);
            long lastModified = child.getLastModified();
            boolean updateCache = false;
            if (previous == null) {
                updateCache = true;
            } else if (lastModified > previous) {
                lastModified = this.getSynchAdapter().update(file, child);
                updateCache = true;
            }
            if (updateCache) {
                this.getCache().putCacheValue(originalPathName, lastModified);
            }
        }
    }
}

