/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.descriptor.plugin.ParentResourceType;
import org.rhq.core.clientapi.descriptor.plugin.PlatformDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.RunsInsideType;
import org.rhq.core.clientapi.descriptor.plugin.ServerDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServiceDescriptor;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.exception.WrappedRemotingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AgentPluginDescriptorUtil {
    private static final Log LOG = LogFactory.getLog(AgentPluginDescriptorUtil.class);
    private static final String PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-plugin.xml";
    private static final String PLUGIN_SCHEMA_PATH = "rhq-plugin.xsd";

    public static Plugin determineObsoletePlugin(Plugin plugin1, Plugin plugin2) {
        String version2Str;
        ComparableVersion plugin2Version;
        if (!plugin1.getName().equals(plugin2.getName())) {
            throw new IllegalArgumentException("The two plugins don't have the same name:" + plugin1 + ":" + plugin2);
        }
        if (plugin1.getMd5().equals(plugin2.getMd5())) {
            return null;
        }
        String version1Str = plugin1.getVersion();
        ComparableVersion plugin1Version = new ComparableVersion(version1Str != null ? version1Str : "0");
        if (plugin1Version.equals((Object)(plugin2Version = new ComparableVersion((version2Str = plugin2.getVersion()) != null ? version2Str : "0")))) {
            if (plugin1.getMtime() == plugin2.getMtime()) {
                LOG.info((Object)("Plugins [" + plugin1 + ", " + plugin2 + "] are the same logical plugin but have different content. The plugin [" + plugin1 + "] will be considered obsolete."));
                return plugin1;
            }
            if (plugin1.getMtime() < plugin2.getMtime()) {
                return plugin1;
            }
            return plugin2;
        }
        if (plugin1Version.compareTo((Object)plugin2Version) < 0) {
            return plugin1;
        }
        return plugin2;
    }

    public static ComparableVersion getPluginVersion(File pluginFile, PluginDescriptor descriptor) throws Exception {
        Manifest manifest;
        String version;
        if (descriptor == null) {
            descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl(pluginFile.toURI().toURL());
        }
        if ((version = descriptor.getVersion()) == null && (manifest = AgentPluginDescriptorUtil.getManifest(pluginFile)) != null) {
            version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        if (version == null) {
            throw new Exception("No version is defined for plugin jar [" + pluginFile + "]. A version must be defined either via the MANIFEST.MF [" + Attributes.Name.IMPLEMENTATION_VERSION + "] attribute or via the plugin descriptor 'version' attribute.");
        }
        try {
            return new ComparableVersion(version);
        }
        catch (RuntimeException e) {
            throw new Exception("Version [" + version + "] for [" + pluginFile + "] did not parse", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(File pluginFile) {
        Manifest manifest;
        JarFile jarFile = new JarFile(pluginFile);
        try {
            Manifest manifest2;
            manifest = manifest2 = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        jarFile.close();
        return manifest;
    }

    public static void addPluginToDependencyGraph(PluginDependencyGraph dependencyGraph, PluginDescriptor descriptor) {
        String pluginName = descriptor.getName();
        ArrayList<PluginDependencyGraph.PluginDependency> dependencies = new ArrayList<PluginDependencyGraph.PluginDependency>();
        for (PluginDescriptor.Depends dependency : descriptor.getDepends()) {
            String dependencyName = dependency.getPlugin();
            boolean useClasses = dependency.isUseClasses();
            boolean required = true;
            dependencies.add(new PluginDependencyGraph.PluginDependency(dependencyName, useClasses, required));
        }
        List<PlatformDescriptor> platforms = descriptor.getPlatforms();
        List<ServerDescriptor> servers = descriptor.getServers();
        List<ServiceDescriptor> services = descriptor.getServices();
        for (PlatformDescriptor platform : platforms) {
            AgentPluginDescriptorUtil.addOptionalDependency(platform, dependencies);
        }
        for (ServerDescriptor server : servers) {
            AgentPluginDescriptorUtil.addOptionalDependency(server, dependencies);
        }
        for (ServiceDescriptor service : services) {
            AgentPluginDescriptorUtil.addOptionalDependency(service, dependencies);
        }
        dependencyGraph.addPlugin(pluginName, dependencies);
    }

    private static void addOptionalDependency(PlatformDescriptor platform, List<PluginDependencyGraph.PluginDependency> dependencies) {
        for (ServerDescriptor childServer : platform.getServers()) {
            AgentPluginDescriptorUtil.addOptionalDependency(childServer, dependencies);
        }
        for (ServiceDescriptor childService : platform.getServices()) {
            AgentPluginDescriptorUtil.addOptionalDependency(childService, dependencies);
        }
        AgentPluginDescriptorUtil.addOptionalDependency(platform.getRunsInside(), dependencies);
    }

    private static void addOptionalDependency(ServerDescriptor server, List<PluginDependencyGraph.PluginDependency> dependencies) {
        for (ServerDescriptor childServer : server.getServers()) {
            AgentPluginDescriptorUtil.addOptionalDependency(childServer, dependencies);
        }
        for (ServiceDescriptor childService : server.getServices()) {
            AgentPluginDescriptorUtil.addOptionalDependency(childService, dependencies);
        }
        AgentPluginDescriptorUtil.addOptionalDependency(server.getRunsInside(), dependencies);
        AgentPluginDescriptorUtil.addOptionalDependency(server.getSourcePlugin(), dependencies);
    }

    private static void addOptionalDependency(ServiceDescriptor service, List<PluginDependencyGraph.PluginDependency> dependencies) {
        for (ServiceDescriptor childService : service.getServices()) {
            AgentPluginDescriptorUtil.addOptionalDependency(childService, dependencies);
        }
        AgentPluginDescriptorUtil.addOptionalDependency(service.getRunsInside(), dependencies);
        AgentPluginDescriptorUtil.addOptionalDependency(service.getSourcePlugin(), dependencies);
    }

    private static void addOptionalDependency(RunsInsideType runsInside, List<PluginDependencyGraph.PluginDependency> dependencies) {
        if (runsInside != null) {
            List<ParentResourceType> parents = runsInside.getParentResourceType();
            for (ParentResourceType parent : parents) {
                AgentPluginDescriptorUtil.addOptionalDependency(parent.getPlugin(), dependencies);
            }
        }
    }

    private static void addOptionalDependency(String pluginName, List<PluginDependencyGraph.PluginDependency> dependencies) {
        boolean required;
        boolean useClasses;
        PluginDependencyGraph.PluginDependency dep;
        if (pluginName != null && !dependencies.contains(dep = new PluginDependencyGraph.PluginDependency(pluginName, useClasses = false, required = false))) {
            dependencies.add(dep);
        }
    }

    public static PluginDescriptor loadPluginDescriptorFromUrl(URL pluginJarFileUrl) throws PluginContainerException {
        JAXBContext jaxbContext;
        Log logger = LogFactory.getLog(AgentPluginDescriptorUtil.class);
        if (pluginJarFileUrl == null) {
            throw new PluginContainerException("A valid plugin JAR URL must be supplied.");
        }
        logger.debug((Object)("Loading plugin descriptor from plugin jar at [" + pluginJarFileUrl + "]..."));
        AgentPluginDescriptorUtil.testPluginJarIsReadable(pluginJarFileUrl);
        try {
            jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        }
        catch (Exception e) {
            throw new PluginContainerException("Failed to create JAXB Context.", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        JarInputStream jis = null;
        JarEntry descriptorEntry = null;
        try {
            jis = new JarInputStream(pluginJarFileUrl.openStream());
            JarEntry nextEntry = jis.getNextJarEntry();
            while (nextEntry != null && descriptorEntry == null) {
                if (PLUGIN_DESCRIPTOR_PATH.equals(nextEntry.getName())) {
                    descriptorEntry = nextEntry;
                    continue;
                }
                jis.closeEntry();
                nextEntry = jis.getNextJarEntry();
            }
            if (descriptorEntry == null) {
                throw new Exception("The plugin descriptor does not exist");
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL pluginSchemaURL = AgentPluginDescriptorUtil.class.getClassLoader().getResource(PLUGIN_SCHEMA_PATH);
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            unmarshaller.setSchema(pluginSchema);
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            PluginDescriptor pluginDescriptor = (PluginDescriptor)unmarshaller.unmarshal((InputStream)jis);
            for (ValidationEvent event : vec.getEvents()) {
                logger.debug((Object)("Plugin [" + pluginDescriptor.getName() + "] descriptor messages {Severity: " + event.getSeverity() + ", Message: " + event.getMessage() + ", Exception: " + event.getLinkedException() + "}"));
            }
            PluginDescriptor pluginDescriptor2 = pluginDescriptor;
            return pluginDescriptor2;
        }
        catch (Exception e) {
            throw new PluginContainerException("Could not successfully parse the plugin descriptor [META-INF/rhq-plugin.xml found in plugin jar at [" + pluginJarFileUrl + "]", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot close jar stream [" + pluginJarFileUrl + "]. Cause: " + e));
                }
            }
        }
    }

    private static void testPluginJarIsReadable(URL pluginJarFileUrl) throws PluginContainerException {
        InputStream inputStream = null;
        try {
            inputStream = pluginJarFileUrl.openStream();
        }
        catch (IOException e) {
            throw new PluginContainerException("Unable to open plugin jar at [" + pluginJarFileUrl + "] for reading.");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

