/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.embedded;

import javax.management.MBeanServer;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.spi.core.security.HornetQSecurityManagerImpl;

public class EmbeddedHornetQ {
    protected HornetQSecurityManager securityManager;
    protected String configResourcePath = null;
    protected Configuration configuration;
    protected HornetQServer hornetQServer;
    protected MBeanServer mbeanServer;

    public void setConfigResourcePath(String filename) {
        this.configResourcePath = filename;
    }

    public void setSecurityManager(HornetQSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public HornetQServer getHornetQServer() {
        return this.hornetQServer;
    }

    public void start() throws Exception {
        this.initStart();
        this.hornetQServer.start();
    }

    protected void initStart() throws Exception {
        if (this.configuration == null) {
            if (this.configResourcePath == null) {
                this.configResourcePath = "hornetq-configuration.xml";
            }
            FileConfiguration config = new FileConfiguration();
            config.setConfigurationUrl(this.configResourcePath);
            config.start();
            this.configuration = config;
        }
        if (this.securityManager == null) {
            this.securityManager = new HornetQSecurityManagerImpl();
        }
        this.hornetQServer = this.mbeanServer == null ? new HornetQServerImpl(this.configuration, this.securityManager) : new HornetQServerImpl(this.configuration, this.mbeanServer, this.securityManager);
    }

    public void stop() throws Exception {
        this.hornetQServer.stop();
    }
}

