/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployment;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jpa.util.ThreadLocalStack;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxUtils;

public class ManagedEntityManagerFactory {
    private static final Logger log = Logger.getLogger(ManagedEntityManagerFactory.class);
    protected EntityManagerFactory entityManagerFactory;
    protected TransactionLocal session = new TransactionLocal();
    protected String kernelName;
    public static ThreadLocalStack<Map<ManagedEntityManagerFactory, EntityManager>> nonTxStack = new ThreadLocalStack();

    public EntityManager getNonTxEntityManager() {
        Map<ManagedEntityManagerFactory, EntityManager> map = nonTxStack.get();
        EntityManager em = null;
        if (map != null) {
            em = map.get(this);
        } else {
            map = new HashMap<ManagedEntityManagerFactory, EntityManager>();
            nonTxStack.push(map);
        }
        if (em == null) {
            em = this.entityManagerFactory.createEntityManager();
            map.put(this, em);
        }
        return em;
    }

    public ManagedEntityManagerFactory(EntityManagerFactory sf, String kernelName) {
        this.entityManagerFactory = sf;
        this.kernelName = kernelName;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public void destroy() {
        this.entityManagerFactory.close();
    }

    public TransactionLocal getTransactionSession() {
        return this.session;
    }

    public void registerExtendedWithTransaction(EntityManager pc) {
        pc.joinTransaction();
        this.session.set((Object)pc);
    }

    public void verifyInTx() {
        Transaction tx = this.session.getTransaction();
        if (tx == null || !TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("EntityManager must be access within a transaction");
        }
        if (!TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("Transaction must be active to access EntityManager");
        }
    }

    public boolean isInTx() {
        Transaction tx = this.session.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public EntityManager getTransactionScopedEntityManager() {
        Transaction tx = this.session.getTransaction();
        if (tx == null || !TxUtils.isActive((Transaction)tx)) {
            return this.getNonTxEntityManager();
        }
        EntityManager rtnSession = (EntityManager)this.session.get();
        if (rtnSession == null) {
            rtnSession = this.createEntityManager();
            try {
                tx.registerSynchronization((Synchronization)new SessionSynchronization(rtnSession, tx, true));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            this.session.set((Object)rtnSession);
            rtnSession.joinTransaction();
        }
        return rtnSession;
    }

    public EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private boolean closeAtTxCompletion;

        public SessionSynchronization(EntityManager session, Transaction tx, boolean close) {
            this.manager = session;
            this.closeAtTxCompletion = close;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                log.debug((Object)"************** closing entity managersession **************");
                this.manager.close();
            }
        }
    }
}

