/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.jpa.jbpapp9336;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author Navin Surtani (navssurtani)
 *
 * Class that is a JPA Entity that will contain an attribute named 'handler' in order to test the functionality for Javassist upgrade from
 * 3.12.0.GA to the SP.
 */

@Entity
public class EntityWithHandlerAttribute implements Serializable {
    
    private Long id;
    private String handler;
    
    /**
     * 
     * @return - the id of the instance.
     */
    @Id
    @GeneratedValue (strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }
    /**
     * 
     * @return - the handler.
     */
    public String getHandler() {
        return this.handler;
    }
    
    public void setId(Long id){
        this.id = id;
    }
    
    public void setHandler(String handler){
        this.handler = handler;
    }
    
    
}
