#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh

if [ -f sources ]; then
    sd=`cat sources | head -n 1`
    if [ ".$sd" = . ]; then
        exit 22
    fi
    if [ -d "$sd/jni/native" ]; then
        $XB_VERBOSE "Making tomcat-native..."
        $XB_VERBOSE "  prefix      : \`$XB_BUILD_ROOT$o_prefix'"
        $XB_VERBOSE "  libdir      : \`$XB_BUILD_ROOT$o_prefix/$libd'"
        $XB_VERBOSE "  temp root   : \`$XB_BUILD_RTMP'"
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi

        xbcnewdir 077 "$XB_BUILD_RTMP"
        cd "$sd/jni/native"
        if $xb_build_clean; then
            make clean
        fi
        make
        make DESTDIR="$XB_BUILD_RTMP" install

        chmod 755 $XB_BUILD_RTMP$o_prefix/$libd/lib*.so* >/dev/null 2>&1 || true
        chmod 755 $XB_BUILD_RTMP$o_prefix/$libd/lib*.$XB_DLL_EXT* >/dev/null 2>&1 || true
        chmod 644 $XB_BUILD_RTMP$o_prefix/$libd/lib*.a >/dev/null 2>&1 || true
        xbcopypdir "$XB_BUILD_RTMP$o_prefix/$libd" "$XB_BUILD_ROOT$o_prefix/$libd"
    else
        exit 20
    fi
else
    exit 2
fi

exit 0
