#!/bin/sh
# Copyright(c) 2009 Red Hat Middleware, LLC,
# and individual contributors as indicated by the @authors tag.
# See the copyright.txt in the distribution for a
# full listing of individual contributors.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh

if [ -f sources ]; then
    sd=`cat sources | head -n 1`
    if [ ".$sd" = . ]; then
        exit 22
    fi
    if [ -d "$sd" ]; then
        $XB_VERBOSE "Making zlib..."
        $XB_VERBOSE "  prefix      : \`$XB_BUILD_ROOT$o_prefix'"
        $XB_VERBOSE "  libdir      : \`$XB_BUILD_ROOT$o_prefix/$libd'"
        $XB_VERBOSE "  temp root   : \`$XB_BUILD_RTMP'"
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi

        xbcnewdir 077 "$XB_BUILD_RTMP"
        cd $sd
        if $xb_build_clean; then
            make -f Makefile.shared clean
        fi
        make -f Makefile.shared
        make -f Makefile.shared prefix="$XB_BUILD_RTMP" \
                 libdir="$XB_BUILD_RTMP/lib" install

        if $xb_build_clean; then
            make -f Makefile.static clean
        fi
        make -f Makefile.static
        make -f Makefile.static prefix="$XB_BUILD_RTMP" \
                 libdir="$XB_BUILD_RTMP/lib" install

        # Install package
        chmod 755 $XB_BUILD_RTMP/lib/lib*.so* >/dev/null 2>&1 || true
        chmod 644 $XB_BUILD_RTMP/lib/lib*.a >/dev/null 2>&1 || true
        chmod 644 $XB_BUILD_RTMP/include/* >/dev/null 2>&1 || true
        mv $XB_BUILD_RTMP/include/* "$XB_BUILD_ROOT$o_prefix/include" >/dev/null 2>&1 || true
        shpx=""
        if [ -d "$XB_BUILD_RTMP/share/man" ]; then
            shpx="/share"
        fi
        chmod 644 $XB_BUILD_RTMP$shpx/man/man3/* >/dev/null 2>&1 || true
        mv $XB_BUILD_RTMP$shpx/man/man3/* "$XB_BUILD_ROOT$o_prefix/man/man3/" >/dev/null 2>&1 || true
        xbcopypdir "$XB_BUILD_RTMP/lib" "$XB_BUILD_ROOT$o_prefix/$libd"
    else
        exit 20
    fi
else
    exit 2
fi

exit 0
