/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.SSLContext;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.ssl.JsseAcceptingSslStreamChannel;
import org.xnio.ssl.JsseConnectedSslStreamChannel;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.XnioSsl;

public final class JsseXnioSsl
extends XnioSsl {
    private static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    private final Pool<ByteBuffer> socketBufferPool;
    private final Pool<ByteBuffer> applicationBufferPool;
    private final SSLContext sslContext;

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, JsseSslUtils.createSSLContext(optionMap));
    }

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap, SSLContext sslContext) {
        super(xnio, sslContext, optionMap);
        int appBufSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_SIZE, 17000);
        int pktBufSize = optionMap.get(Options.SSL_PACKET_BUFFER_SIZE, 17000);
        int appBufRegionSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_REGION_SIZE, appBufSize * 16);
        int pktBufRegionSize = optionMap.get(Options.SSL_PACKET_BUFFER_REGION_SIZE, pktBufSize * 16);
        this.socketBufferPool = new ByteBufferSlicePool(optionMap.get(Options.USE_DIRECT_BUFFERS, false) ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, pktBufSize, pktBufRegionSize);
        this.applicationBufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, appBufSize, appBufRegionSize);
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress destination, ChannelListener<? super ConnectedSslStreamChannel> openListener, OptionMap optionMap) {
        return this.connectSsl(worker, ANY_INET_ADDRESS, destination, openListener, null, optionMap);
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress destination, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.connectSsl(worker, ANY_INET_ADDRESS, destination, openListener, bindListener, optionMap);
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super ConnectedSslStreamChannel> openListener, OptionMap optionMap) {
        return this.connectSsl(worker, bindAddress, destination, openListener, null, optionMap);
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        IoFuture<ConnectedStreamChannel> connectedChannelFuture = worker.connectStream(bindAddress, destination, (ChannelListener<? super ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

            @Override
            public void handleEvent(ConnectedStreamChannel tcpChannel) {
                ConnectedSslStreamChannel channel = JsseXnioSsl.this.createSslConnectedStreamChannel(JsseXnioSsl.this.sslContext, tcpChannel, optionMap);
                if (!futureResult.setResult(channel)) {
                    IoUtils.safeClose(channel);
                } else {
                    ChannelListeners.invokeChannelListener(channel, openListener);
                }
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        futureResult.getIoFuture().addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<ConnectedStreamChannel>>(){

            @Override
            public void handleCancelled(IoFuture<ConnectedStreamChannel> result) {
                result.cancel();
            }
        }, connectedChannelFuture);
        futureResult.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                futureResult.setCancelled();
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    @Override
    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        JsseAcceptingSslStreamChannel server = new JsseAcceptingSslStreamChannel(this.sslContext, worker.createStreamServer(bindAddress, null, optionMap), optionMap, this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    ConnectedSslStreamChannel createSslConnectedStreamChannel(SSLContext sslContext, ConnectedStreamChannel tcpChannel, OptionMap optionMap) {
        return new JsseConnectedSslStreamChannel(tcpChannel, JsseSslUtils.createSSLEngine(sslContext, optionMap, tcpChannel.getPeerAddress(InetSocketAddress.class)), this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
    }
}

