/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSourceChannel;

public class BlockingReadableByteChannel
implements ScatteringByteChannel {
    private final StreamSourceChannel delegate;
    private volatile long readTimeout;

    public BlockingReadableByteChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingReadableByteChannel(StreamSourceChannel delegate, long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        this.delegate = delegate;
        long calcTimeout = readTimeoutUnit.toMillis(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setReadTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        long calcTimeout = readTimeoutUnit.toMillis(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        StreamSourceChannel delegate = this.delegate;
        long readTimeout = this.readTimeout;
        if (readTimeout == 0L) {
            while ((res = delegate.read(dsts, offset, length)) == 0L) {
                delegate.awaitReadable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + readTimeout;
            while ((res = delegate.read(dsts, offset, length)) == 0L) {
                if (now >= deadline) {
                    throw new ReadTimeoutException("Read timed out");
                }
                delegate.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        StreamSourceChannel delegate = this.delegate;
        long readTimeout = this.readTimeout;
        if (readTimeout == 0L) {
            while ((long)(res = delegate.read(dst)) == 0L) {
                delegate.awaitReadable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + readTimeout;
            while ((long)(res = delegate.read(dst)) == 0L) {
                if (now >= deadline) {
                    throw new ReadTimeoutException("Read timed out");
                }
                delegate.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

