/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.ejb.security.asynchronous.remotingcontext;

import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.logging.Logger;

import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

@SecurityDomain(RemotingContextAsyncTestCase.SECURITY_DOMAIN_NAME)
@RolesAllowed({})
@Stateless
@Remote(Hello.class)
public class HelloBean implements Hello {
    private static final Logger log = Logger.getLogger(GoodByeBean.class);

    @Resource
    private SessionContext context;

    @EJB
    GoodBye goodBye;

    @PermitAll
    public String sayHello() {
        log.info("principal: " + context.getCallerPrincipal());

        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final Future<String> future = goodBye.sayGoodByeAsync(latch);
            latch.countDown();
            log.info("async result: " + future.get());
        } catch (Exception ex) {
            log.error("unable to get ejb: " + ex.getMessage());
            return ("error message: " + ex.getMessage());
        }

        final String name = context.getCallerPrincipal().getName();
        return "Hello " + name + "!";
    }

}
