/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static final FactoryManagerCache FACTORIES_CACHE = new FactoryManagerCache();
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map<String, Class> factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    public static Object getFactory(String string) throws FacesException {
        FactoryFinder.validateFactoryName(string);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager factoryManager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        return factoryManager.getFactory(classLoader, string);
    }

    public static void setFactory(String string, String string2) {
        FactoryFinder.validateFactoryName(string);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager factoryManager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        factoryManager.addFactory(string, string2);
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FACTORIES_CACHE.removeApplicationFactoryManager(classLoader);
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String string, List list) throws FacesException {
        List<String> list2;
        String string2;
        int n;
        Object object = null;
        if (null != list && (1 < (n = list.size()) || 1 == n)) {
            string2 = (String)list.remove(n - 1);
            object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, null);
        }
        if ((list2 = FactoryFinder.getImplNameFromServices(classLoader, string)) != null) {
            for (String string3 : list2) {
                object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string3, object);
            }
        }
        if (null != list) {
            for (n = list.size() - 1; 0 <= n; --n) {
                string2 = (String)list.remove(n);
                object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getImplNameFromServices(ClassLoader classLoader, String string) {
        ArrayList<String> arrayList;
        block12: {
            arrayList = null;
            String string2 = "META-INF/services/" + string;
            BufferedReader bufferedReader = null;
            try {
                Enumeration<URL> enumeration = classLoader.getResources(string2);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    InputStream inputStream = uRLConnection.getInputStream();
                    if (inputStream == null) continue;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>(3);
                        }
                        arrayList.add(bufferedReader.readLine());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                        if (inputStream == null) continue;
                        inputStream.close();
                        inputStream = null;
                    }
                }
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, securityException.toString(), securityException);
            }
        }
        return arrayList;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String string, String string2, Object object) {
        Class<?> clazz;
        Class clazz2 = null;
        Object[] objectArray = new Object[1];
        Object var9_6 = null;
        if (null != object && null != (clazz2 = FactoryFinder.getFactoryClass(string))) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                objectArray[0] = object;
                var9_6 = constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = null;
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        if (null == object || null == clazz2) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                var9_6 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        return var9_6;
    }

    private static Class getFactoryClass(String string) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap<String, Class>(FACTORY_NAMES.length);
            factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
            factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
            factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
            factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        }
        return factoryClasses.get(string);
    }

    private static void validateFactoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, string) < 0) {
            throw new IllegalArgumentException(string);
        }
    }

    private static final class FactoryManager {
        private final Map<String, Object> factories = new HashMap<String, Object>();
        private final ReentrantReadWriteLock lock;

        public FactoryManager() {
            for (String string : FACTORY_NAMES) {
                this.factories.put(string, new ArrayList(4));
            }
            this.lock = new ReentrantReadWriteLock(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFactory(String string, String string2) {
            Object object = this.factories.get(string);
            this.lock.writeLock().lock();
            try {
                if (object instanceof List) {
                    TypedCollections.dynamicallyCastList((List)object, String.class).add(0, string2);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFactory(ClassLoader classLoader, String string) {
            Object object;
            this.lock.readLock().lock();
            try {
                object = this.factories.get(string);
                if (!(object instanceof List)) {
                    Object object2 = object;
                    return object2;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                object = this.factories.get(string);
                if (!(object instanceof List)) {
                    Object object3 = object;
                    return object3;
                }
                Object object4 = FactoryFinder.getImplementationInstance(classLoader, string, (List)object);
                if (object4 == null) {
                    ResourceBundle resourceBundle = LOGGER.getResourceBundle();
                    String string2 = resourceBundle.getString("severe.no_factory");
                    string2 = MessageFormat.format(string2, string);
                    throw new IllegalStateException(string2);
                }
                this.factories.put(string, object4);
                Object object5 = object4;
                return object5;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static final class FactoryManagerCache {
        private ConcurrentMap<ClassLoader, Future<FactoryManager>> applicationMap = new ConcurrentHashMap<ClassLoader, Future<FactoryManager>>();

        private FactoryManagerCache() {
        }

        /*
         * Loose catch block
         */
        private FactoryManager getApplicationFactoryManager(ClassLoader classLoader) {
            while (true) {
                Callable<FactoryManager> callable;
                FutureTask<FactoryManager> futureTask;
                FutureTask<FactoryManager> futureTask2;
                if ((futureTask2 = (FutureTask<FactoryManager>)this.applicationMap.get(classLoader)) == null && (futureTask2 = (Future)this.applicationMap.putIfAbsent(classLoader, futureTask = new FutureTask<FactoryManager>(callable = new Callable<FactoryManager>(){

                    @Override
                    public FactoryManager call() throws Exception {
                        return new FactoryManager();
                    }
                }))) == null) {
                    futureTask2 = futureTask;
                    futureTask.run();
                }
                try {
                    return (FactoryManager)futureTask2.get();
                }
                catch (CancellationException cancellationException) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, cancellationException.toString(), cancellationException);
                    }
                    this.applicationMap.remove(classLoader);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, interruptedException.toString(), interruptedException);
                    }
                    this.applicationMap.remove(classLoader);
                    continue;
                }
                break;
            }
            catch (ExecutionException executionException) {
                throw new FacesException(executionException);
            }
        }

        public void removeApplicationFactoryManager(ClassLoader classLoader) {
            this.applicationMap.remove(classLoader);
        }
    }
}

