/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

class StateHolderSaver
implements Serializable {
    private static final long serialVersionUID = 6470180891722042701L;
    private String className = null;
    private Serializable savedState = null;

    public StateHolderSaver(FacesContext facesContext, Object object) {
        this.className = object.getClass().getName();
        if (object instanceof StateHolder) {
            if (!((StateHolder)object).isTransient()) {
                this.savedState = (Serializable)((StateHolder)object).saveState(facesContext);
            } else {
                this.className = null;
            }
        } else if (object instanceof Serializable) {
            this.savedState = (Serializable)object;
            this.className = null;
        }
    }

    public Object restore(FacesContext facesContext) throws IllegalStateException {
        Class clazz;
        Object var2_2 = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            clazz = StateHolderSaver.loadClass(this.className, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        if (null != clazz) {
            try {
                var2_2 = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
        }
        if (null != var2_2 && null != this.savedState && var2_2 instanceof StateHolder) {
            ((StateHolder)var2_2).restoreState(facesContext, this.savedState);
        }
        return var2_2;
    }

    private static Class loadClass(String string, Object object) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = object.getClass().getClassLoader();
        }
        return Class.forName(string, false, classLoader);
    }
}

