/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationResourceBundle;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String APPLICATION = "application";
    private static final String ACTION_LISTENER = "action-listener";
    private static final String DEFAULT_RENDERKIT_ID = "default-render-kit-id";
    private static final String MESSAGE_BUNDLE = "message-bundle";
    private static final String NAVIGATION_HANDLER = "navigation-handler";
    private static final String VIEW_HANDLER = "view-handler";
    private static final String STATE_MANAGER = "state-manager";
    private static final String EL_RESOLVER = "el-resolver";
    private static final String PROPERTY_RESOLVER = "property-resolver";
    private static final String VARIABLE_RESOLVER = "variable-resolver";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String SUPPORTED_LOCALE = "supported-locale";
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    private static final String BASE_NAME = "base-name";
    private static final String VAR = "var";
    private static final String RES_DESCRIPTIONS = "description";
    private static final String RES_DISPLAY_NAMES = "display-name";

    @Override
    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        Application application = this.getApplication();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
        for (int i = 0; i < documentArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing application elements for document: ''{0}''", documentArray[i].getDocumentURI()));
            }
            String string = documentArray[i].getDocumentElement().getNamespaceURI();
            NodeList nodeList = documentArray[i].getDocumentElement().getElementsByTagNameNS(string, APPLICATION);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                int n2 = nodeList2.getLength();
                for (int k = 0; k < n2; ++k) {
                    Node node2 = nodeList2.item(k);
                    if (MESSAGE_BUNDLE.equals(node2.getLocalName())) {
                        this.setMessageBundle(application, node2);
                        continue;
                    }
                    if (DEFAULT_RENDERKIT_ID.equals(node2.getLocalName())) {
                        this.setDefaultRenderKitId(application, node2);
                        continue;
                    }
                    if (ACTION_LISTENER.equals(node2.getLocalName())) {
                        this.addActionListener(application, node2);
                        continue;
                    }
                    if (NAVIGATION_HANDLER.equals(node2.getLocalName())) {
                        this.setNavigationHandler(application, node2);
                        continue;
                    }
                    if (VIEW_HANDLER.equals(node2.getLocalName())) {
                        this.setViewHandler(application, node2);
                        continue;
                    }
                    if (STATE_MANAGER.equals(node2.getLocalName())) {
                        this.setStateManager(application, node2);
                        continue;
                    }
                    if (EL_RESOLVER.equals(node2.getLocalName())) {
                        this.addELResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (PROPERTY_RESOLVER.equals(node2.getLocalName())) {
                        this.addPropertyResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (VARIABLE_RESOLVER.equals(node2.getLocalName())) {
                        this.addVariableResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (DEFAULT_LOCALE.equals(node2.getLocalName())) {
                        this.setDefaultLocale(application, node2);
                        continue;
                    }
                    if (SUPPORTED_LOCALE.equals(node2.getLocalName())) {
                        this.addSupportedLocale(application, node2);
                        continue;
                    }
                    if (!RESOURCE_BUNDLE.equals(node2.getLocalName())) continue;
                    this.addResouceBundle(applicationAssociate, node2);
                }
            }
        }
        this.invokeNext(servletContext, documentArray);
    }

    private void setMessageBundle(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setMessageBundle({0})", string));
            }
            application.setMessageBundle(string);
        }
    }

    private void setDefaultRenderKitId(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setDefaultRenderKitId({0})", string));
            }
            application.setDefaultRenderKitId(string);
        }
    }

    private void addActionListener(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, ActionListener.class, application.getActionListener(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setActionListeners({0})", string));
            }
            application.setActionListener((ActionListener)object);
        }
    }

    private void setNavigationHandler(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, NavigationHandler.class, application.getNavigationHandler(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setNavigationHandlers({0})", string));
            }
            application.setNavigationHandler((NavigationHandler)object);
        }
    }

    private void setStateManager(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, StateManager.class, application.getStateManager(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setStateManagers({0})", string));
            }
            application.setStateManager((StateManager)object);
        }
    }

    private void setViewHandler(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, ViewHandler.class, application.getViewHandler(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setViewHandlers({0})", string));
            }
            application.setViewHandler((ViewHandler)object);
        }
    }

    private void addELResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            Object object;
            String string;
            List<ELResolver> list = applicationAssociate.getELResolversFromFacesConfig();
            if (list == null) {
                list = new ArrayList<ELResolver>();
                applicationAssociate.setELResolversFromFacesConfig(list);
            }
            if ((string = this.getNodeText(node)) != null && (object = this.createInstance(string, ELResolver.class, null, node)) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to ELResolver chain", string));
                }
                list.add((ELResolver)object);
            }
        }
    }

    private void addPropertyResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyPRChainHead();
            if (object == null) {
                object = new DummyPropertyResolverImpl();
            }
            if ((string = this.getNodeText(node)) != null) {
                object = this.createInstance(string, PropertyResolver.class, object, node);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to PropertyResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyPRChainHead((PropertyResolver)object);
            }
        }
    }

    private void addVariableResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyVRChainHead();
            if (object == null) {
                object = new ChainAwareVariableResolver();
            }
            if ((string = this.getNodeText(node)) != null) {
                object = this.createInstance(string, VariableResolver.class, object, node);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to VariableResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyVRChainHead((VariableResolver)object);
            }
        }
    }

    private void setDefaultLocale(Application application, Node node) {
        Locale locale;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (locale = Util.getLocaleFromString(string)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Setting default Locale to ''{0}''", string));
            }
            application.setDefaultLocale(locale);
        }
    }

    private void addSupportedLocale(Application application, Node node) {
        if (node != null) {
            Set<Locale> set = this.getCurrentLocales(application);
            String string = this.getNodeText(node);
            if (string != null) {
                Locale locale = Util.getLocaleFromString(string);
                if (locale != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding supported Locale ''{0}''", string));
                    }
                    set.add(locale);
                }
                application.setSupportedLocales(set);
            }
        }
    }

    private void addResouceBundle(ApplicationAssociate applicationAssociate, Node node) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            String string = null;
            String string2 = null;
            ArrayList<Node> arrayList = null;
            ArrayList<Node> arrayList2 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (BASE_NAME.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (VAR.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (RES_DESCRIPTIONS.equals(node2.getLocalName())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Node>(2);
                    }
                    arrayList.add(node2);
                    continue;
                }
                if (!RES_DISPLAY_NAMES.equals(node2.getLocalName())) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node>(2);
                }
                arrayList2.add(node2);
            }
            if (string != null && string2 != null) {
                applicationAssociate.addResourceBundle(string2, new ApplicationResourceBundle(string, this.getTextMap(arrayList2), this.getTextMap(arrayList)));
            }
        }
    }

    private Set<Locale> getCurrentLocales(Application application) {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        Iterator iterator = application.getSupportedLocales();
        while (iterator.hasNext()) {
            hashSet.add((Locale)iterator.next());
        }
        return hashSet;
    }
}

