/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ApplicationObjectInputStream;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationProviderFactory {
    private static final SerializationProvider JAVA_PROVIDER = new JavaSerializationProvider();
    private static final String SERIALIZATION_PROVIDER_PROPERTY = "com.sun.faces.SerializationProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static SerializationProvider createInstance(ExternalContext externalContext) {
        String string = SerializationProviderFactory.findProviderClass(externalContext);
        SerializationProvider serializationProvider = SerializationProviderFactory.getProviderInstance(string);
        if (serializationProvider.getClass() != JavaSerializationProvider.class && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.spi.serialization.provider_configured", new Object[]{serializationProvider.getClass().getName()});
        }
        return serializationProvider;
    }

    private static SerializationProvider getProviderInstance(String string) {
        SerializationProvider serializationProvider;
        block10: {
            serializationProvider = JAVA_PROVIDER;
            if (string != null) {
                try {
                    Class clazz = Util.loadClass(string, SerializationProviderFactory.class);
                    if (SerializationProviderFactory.implementsSerializationProvider(clazz)) {
                        serializationProvider = (SerializationProvider)clazz.newInstance();
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_not_implemented", new Object[]{string});
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_not_found", new Object[]{string});
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_cannot_instantiate", new Object[]{string});
                        LOGGER.log(Level.SEVERE, "", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_cannot_instantiate", new Object[]{string});
                    LOGGER.log(Level.SEVERE, "", illegalAccessException);
                }
            }
        }
        return serializationProvider;
    }

    private static boolean implementsSerializationProvider(Class<?> clazz) {
        return SerializationProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext externalContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(externalContext);
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.SerializationProviderClass);
        if (string != null) {
            return string;
        }
        return System.getProperty(SERIALIZATION_PROVIDER_PROPERTY);
    }

    private static final class JavaSerializationProvider
    implements SerializationProvider {
        private JavaSerializationProvider() {
        }

        public ObjectOutputStream createObjectOutputStream(OutputStream outputStream) throws IOException {
            return new ObjectOutputStream(outputStream);
        }

        public ObjectInputStream createObjectInputStream(InputStream inputStream) throws IOException {
            return new ApplicationObjectInputStream(inputStream);
        }
    }
}

