/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.ContentTypeUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlResponseWriterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRenderKitImpl
extends RenderKit {
    private static final Logger log = Logger.getLogger(HtmlRenderKitImpl.class.getName());
    private Map<String, Map<String, Renderer>> _renderers = new ConcurrentHashMap<String, Map<String, Renderer>>(64, 0.75f, 1);
    private ResponseStateManager _responseStateManager = new HtmlResponseStateManager();
    private Map<String, ClientBehaviorRenderer> _clientBehaviorRenderers = new HashMap<String, ClientBehaviorRenderer>();

    public void addClientBehaviorRenderer(String type, ClientBehaviorRenderer renderer) {
        if (type == null) {
            throw new NullPointerException("client behavior renderer type must not be null");
        }
        if (renderer == null) {
            throw new NullPointerException("client behavior renderer must not be null");
        }
        this._clientBehaviorRenderers.put(type, renderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String type) {
        if (type == null) {
            throw new NullPointerException("client behavior renderer type must not be null");
        }
        return this._clientBehaviorRenderers.get(type);
    }

    public Iterator<String> getClientBehaviorRendererTypes() {
        return this._clientBehaviorRenderers.keySet().iterator();
    }

    public Renderer getRenderer(String componentFamily, String rendererType) {
        if (componentFamily == null) {
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            throw new NullPointerException("renderer type must not be null.");
        }
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        Renderer renderer = null;
        if (familyRendererMap != null) {
            renderer = familyRendererMap.get(rendererType);
        }
        if (renderer == null) {
            log.warning("Unsupported component-family/renderer-type: " + componentFamily + "/" + rendererType);
        }
        return renderer;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        if (componentFamily == null) {
            log.severe("addRenderer: componentFamily = null is not allowed");
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            log.severe("addRenderer: rendererType = null is not allowed");
            throw new NullPointerException("renderer type must not be null.");
        }
        if (renderer == null) {
            log.severe("addRenderer: renderer = null is not allowed");
            throw new NullPointerException("renderer must not be null.");
        }
        this._put(componentFamily, rendererType, renderer);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("add Renderer family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName());
        }
    }

    private synchronized void _put(String componentFamily, String rendererType, Renderer renderer) {
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        if (familyRendererMap == null) {
            familyRendererMap = new ConcurrentHashMap<String, Renderer>(8, 0.75f, 1);
            this._renderers.put(componentFamily, familyRendererMap);
        } else if (familyRendererMap.get(rendererType) != null) {
            log.fine("Overwriting renderer with family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName());
        }
        familyRendererMap.put(rendererType, renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public Iterator<String> getComponentFamilies() {
        return this._renderers.keySet().iterator();
    }

    public Iterator<String> getRendererTypes(String componentFamily) {
        Map<String, Renderer> map = this._renderers.get(componentFamily);
        if (map != null) {
            return map.keySet().iterator();
        }
        return Collections.emptySet().iterator();
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeListString, String characterEncoding) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
        String selectedContentType = null;
        String writerContentType = null;
        boolean isAjaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
        String contentTypeListStringFromAccept = null;
        if (contentTypeListString != null) {
            selectedContentType = ContentTypeUtils.chooseWriterContentType(contentTypeListString, ContentTypeUtils.HTML_ALLOWED_CONTENT_TYPES, isAjaxRequest ? ContentTypeUtils.AJAX_XHTML_ALLOWED_CONTENT_TYPES : ContentTypeUtils.XHTML_ALLOWED_CONTENT_TYPES);
        }
        if (selectedContentType == null && (contentTypeListStringFromAccept = ContentTypeUtils.getContentTypeFromAcceptHeader(facesContext)) != null) {
            selectedContentType = ContentTypeUtils.chooseWriterContentType(contentTypeListStringFromAccept, ContentTypeUtils.HTML_ALLOWED_CONTENT_TYPES, isAjaxRequest ? ContentTypeUtils.AJAX_XHTML_ALLOWED_CONTENT_TYPES : ContentTypeUtils.XHTML_ALLOWED_CONTENT_TYPES);
        }
        if (selectedContentType == null) {
            if (contentTypeListString == null && contentTypeListStringFromAccept == null) {
                selectedContentType = myfacesConfig.getDefaultResponseWriterContentTypeMode();
            } else {
                String[] contentTypes;
                if (contentTypeListString != null && ContentTypeUtils.containsContentType("*/*", contentTypes = ContentTypeUtils.splitContentTypeListString(contentTypeListString))) {
                    selectedContentType = myfacesConfig.getDefaultResponseWriterContentTypeMode();
                }
                if (selectedContentType == null) {
                    if (contentTypeListStringFromAccept != null) {
                        contentTypes = ContentTypeUtils.splitContentTypeListString(contentTypeListStringFromAccept);
                        if (ContentTypeUtils.containsContentType("*/*", contentTypes)) {
                            selectedContentType = myfacesConfig.getDefaultResponseWriterContentTypeMode();
                        }
                    } else if (isAjaxRequest) {
                        selectedContentType = myfacesConfig.getDefaultResponseWriterContentTypeMode();
                    }
                    if (selectedContentType == null) {
                        throw new IllegalArgumentException("ContentTypeList does not contain a supported content type: " + (contentTypeListString != null ? contentTypeListString : contentTypeListStringFromAccept));
                    }
                }
            }
        }
        if (isAjaxRequest) {
            writerContentType = selectedContentType.indexOf("application/xhtml+xml") != -1 ? "application/xhtml+xml" : "text/html";
        } else {
            String string = writerContentType = HtmlRendererUtils.isXHTMLContentType(selectedContentType) ? "application/xhtml+xml" : "text/html";
        }
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        return new HtmlResponseWriterImpl(writer, selectedContentType, characterEncoding, myfacesConfig.isWrapScriptContentWithXmlCommentTag(), writerContentType);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return new MyFacesResponseStream(outputStream);
    }

    private void checkNull(Object value, String valueLabel) {
        if (value == null) {
            throw new NullPointerException(valueLabel + " is null");
        }
    }

    private static class MyFacesResponseStream
    extends ResponseStream {
        private OutputStream output;

        public MyFacesResponseStream(OutputStream output) {
            this.output = output;
        }

        public void write(int b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
        }

        public void flush() throws IOException {
            this.output.flush();
        }

        public void close() throws IOException {
            this.output.close();
        }
    }
}

