/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.wildfly.microprofile.opentracing.smallrye;

/**
 * Copied fron the upstream opentracing-smallrye module
 * @author Emmanuel Hugonnet (c) 2019 Red Hat, Inc.
 */
public class TracerConfigurationConstants {
    public static final String SMALLRYE_OPENTRACING_SERVICE_NAME = "smallrye.opentracing.serviceName";
    public static final String SMALLRYE_OPENTRACING_TRACER = "mp.opentracing.extensions.tracer";
    public static final String SMALLRYE_OPENTRACING_TRACER_CONFIGURATION = "mp.opentracing.extensions.tracer.configuration";
    public static final String SMALLRYE_OPENTRACING_TRACER_MANAGED = "mp.opentracing.extensions.tracer.managed";

    public static final String TRACER_CONFIGURATION = "tracer-configuration";
    public static final String TRACER_CONFIGURATION_NAME = "tracer-configuration-name";

    public static final String DEFAULT_TRACER = "default-tracer";
    public static final String PROPAGATION = "propagation";

    public static final String SAMPLER_TYPE = "sampler-type";
    public static final String SAMPLER_PARAM = "sampler-param";
    public static final String SAMPLER_MANAGER_HOST_PORT = "sampler-manager-host-port";

    public static final String SENDER_AGENT_BINDING = "sender-binding";
    public static final String SENDER_ENDPOINT = "sender-endpoint";
    public static final String SENDER_AUTH_TOKEN = "sender-auth-token";
    public static final String SENDER_AUTH_USER = "sender-auth-user";
    public static final String SENDER_AUTH_PASSWORD = "sender-auth-password";

    public static final String REPORTER_LOG_SPANS = "reporter-log-spans";
    public static final String REPORTER_FLUSH_INTERVAL = "reporter-flush-interval";
    public static final String REPORTER_MAX_QUEUE_SIZE = "reporter-max-queue-size";

    public static final String TRACEID_128BIT = "tracer_id_128bit";
    public static final String TRACER_TAGS = "tags";
}
