/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.microprofile.config.smallrye;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.SUBSYSTEM;
import static org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigExtension.SUBSYSTEM_NAME;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class MicroProfileConfigMigrateTestCase extends AbstractSubsystemTest {

    public MicroProfileConfigMigrateTestCase() {
        super(SUBSYSTEM_NAME, new MicroProfileConfigExtension());
    }

    @Test
    public void migrateTest() throws Exception {
        KernelServices services =
                createKernelServicesBuilder(new MicroProfileConfigAdditionalInit())
                        .setSubsystemXmlResource("subsystem_1_0.xml")
                        .build();

        ModelNode legacyModel = services.readWholeModel();
        Assert.assertTrue(legacyModel.get(SUBSYSTEM).hasDefined(SUBSYSTEM_NAME));

        ModelNode migrateOp = Util.createOperation(MicroProfileConfigMigrateOperation.MIGRATE, PathAddress.pathAddress(SUBSYSTEM, SUBSYSTEM_NAME));
        checkOutcome(services.executeOperation(migrateOp));

        ModelNode model = services.readWholeModel();

        Assert.assertFalse(model.get(SUBSYSTEM).hasDefined(SUBSYSTEM_NAME));
    }
}
