package org.jboss.installer.core;

import java.util.Objects;

public class ValidationResult {

    private final String message;

    public enum Result {
        ERROR, OK, WARNING

    }
    private final Result result;

    private ValidationResult(Result result, String message) {
        this.result = result;
        this.message = message;
    }

    public static ValidationResult error(String message) {
        return new ValidationResult(Result.ERROR, message);
    }

    public static ValidationResult ok() {
        return new ValidationResult(Result.OK, null);
    }

    public static ValidationResult warning(String message) {
        return new ValidationResult(Result.WARNING, message);
    }

    public String getMessage() {
        return message;
    }

    public Result getResult() {
        return result;
    }

    @Override
    public String toString() {
        return "ValidationResult{" +
                "message='" + message + '\'' +
                ", result=" + result +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValidationResult that = (ValidationResult) o;
        return Objects.equals(message, that.message) && result == that.result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(message, result);
    }
}
