/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.actions;

public abstract class ActionResult {

    protected String message;

    public static ActionResult success() {
        return new Success();
    }

    public static ActionResult error(String message) {
        return new Error(message);
    }

    public String getMessage() {
        return message;
    }

    public abstract boolean isSuccess();

    static class Success extends ActionResult {
        @Override
        public boolean isSuccess() {
            return true;
        }
    }

    static class Error extends ActionResult {
        private Error(String message) {
            this.message = message;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }
    }
}
