package org.jboss.installer.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionGetter {

    private final String propertyFileName;

    public VersionGetter() {
        this.propertyFileName = "pom_extracted.properties";
    }

    public VersionGetter(String propertyFileName) {
        this.propertyFileName = propertyFileName;
    }

    public String getVersionFromPomProperties(String propertyName) {
        Properties properties = new Properties();
        try (final InputStream inputStream = FileUtils.class.getClassLoader().getResourceAsStream(propertyFileName)) {
            properties.load(inputStream);
            if (!properties.containsKey(propertyName)) {
                throw new InstallerRuntimeException("Unable to determine required version from properties.");
            }
        } catch (IOException e) {
            throw new InstallerRuntimeException("Unable to determine required version from properties.", e);
        }

        return properties.getProperty(propertyName);
    }
}
