/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.LanguageUtils;

import javax.swing.JPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;


public class InstallationOverviewScreen extends DefaultScreen{

    public static final String NAME= "InstallationOverviewScreen";

    public static final String TITLE_KEY="installation_overview_screen.title";
    public static final String DESCRIPTION_KEY="installation_overview_screen.description";
    public static final String PATH_KEY="installation_overview_screen.path";
    public static final String REPOS_KEY="installation_overview_screen.repositories";
    public static final String SUMMARY_KEY = "installation_overview_screen.summary";
    public static final String ADMIN_KEY="installation_overview_screen.admin";
    public static final String USERNAME_KEY = "installation_overview_screen.username";

    private Path targetPath;
    private String adminUsername;
    private List<String> selectedPackages;
    private Map<String, URL> mavenRepositories;

    public InstallationOverviewScreen(LanguageUtils langUtils) {
        super(langUtils);
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JPanel getContent() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        final GridBagConstraints c = initializeConstraints();

        c.insets = DESCRIPTION_INSET;
        content.add(createDescription(DESCRIPTION_KEY), c);
        c.gridy++;

        c.insets = FIELD_ROW_INSET;
        content.add(createSubHeadingLabel(PATH_KEY), c);
        c.gridy++;

        c.insets = SUBSECTION_INSET;
        content.add(createFieldLabel(targetPath.toString(), false), c);
        c.gridy++;

        c.insets = FIELD_ROW_INSET;
        content.add(createSubHeadingLabel(REPOS_KEY), c);
        c.gridy++;

        c.insets = SUBSECTION_INSET;
        for (Map.Entry<String, URL> repo : mavenRepositories.entrySet()) {
            content.add(createFieldLabel(repo.getValue().toExternalForm(), false), c);
            c.gridy++;
        }

        c.insets = FIELD_ROW_INSET;
        content.add(createSubHeadingLabel(SUMMARY_KEY), c);
        c.gridy++;

        c.insets = SUBSECTION_INSET;
        for (String text  : selectedPackages) {
            content.add(createFieldLabel(text), c);
            c.gridy++;
        }

        c.insets = FIELD_ROW_INSET;
        content.add(createSubHeadingLabel(ADMIN_KEY), c);
        c.gridy++;

        c.insets = SUBSECTION_INSET;
        content.add(createFieldLabel(langUtils.getString(USERNAME_KEY) + " " + adminUsername, false), c);
        c.gridy++;

        fillEmptySpace(content,c);

        return content;
    }

    @Override
    public void load(InstallationData installationData) {
        targetPath = installationData.getTargetFolder();
        mavenRepositories = installationData.getMavenRepositories();
        selectedPackages = installationData.getSelectedPackages();
        adminUsername = installationData.getAdminUsername();
    }
}
