package org.jboss.installer.core;

import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ValidationResult {

    private final List<String> messages;

    public enum Result {
        ERROR, OK, WARNING

    }
    private final Result result;

    private ValidationResult(Result result, List<String> messages) {
        this.result = result;
        this.messages = messages == null? Collections.emptyList():messages;
    }

    public static ValidationResult error(String message) {
        return new ValidationResult(Result.ERROR, List.of(message));
    }

    public static ValidationResult ok() {
        return new ValidationResult(Result.OK, null);
    }

    public static ValidationResult warning(String message) {
        return new ValidationResult(Result.WARNING, List.of(message));
    }

    public static ValidationResult warning(List<String> message) {
        return new ValidationResult(Result.WARNING, message);
    }

    public String getMessage() {
        if (messages.isEmpty()) {
            return null;
        }
        if (messages.size() == 1) {
            return messages.get(0);
        }
        return StringUtils.join(messages, "\n");
    }

    public List<String> getMessages() {
        return messages;
    }

    public Result getResult() {
        return result;
    }

    @Override
    public String toString() {
        return "ValidationResult{" +
                "messages=" + messages +
                ", result=" + result +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValidationResult that = (ValidationResult) o;
        return Objects.equals(messages, that.messages) && result == that.result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(messages, result);
    }
}
