package org.jboss.installer.core;

import org.junit.Assert;
import org.junit.Test;

public class BuildPropertiesTest {

    BuildProperties buildProperties = new BuildProperties("pom_test.properties");

    @Test
    public void getExistentVersionTest() {
        String testVersion = buildProperties.getProperty("test.version");
        Assert.assertEquals("test", testVersion);
    }

    @Test
    public void getNonExistentPropertyThrowsExceptionTest() {
        Assert.assertThrows(InstallerRuntimeException.class, () -> {
            buildProperties.getProperty("non.existent.version");
        });
    }
}
