package org.jboss.installer;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.i18n.DefaultLanguageUtils;

import java.util.Locale;

public class SpinningBar extends Thread {

    private boolean running = false;
    public static final String PROCESSING_COMPLETED = "processing_screen.complete";

    public boolean isRunning() {
        return running;
    }

    @SuppressWarnings("BusyWait")
    public void run() {
        running = true;
        String chars = "|/-\\-";
        int x = 0;
        while (running) {
            System.out.print("\r Processing " + chars.charAt(x++ % chars.length()));
            try {
                Thread.sleep(100);
            } catch (Exception e) {
            }
        }
    }

    public void finish() {
        running = false;
        interrupt();
        LanguageUtils langUtils = new DefaultLanguageUtils.Builder().setLocale(Locale.getDefault()).build();
        System.out.print("\r " + langUtils.getString(PROCESSING_COMPLETED));
    }
}
