package org.jboss.installer.validators;

import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Assert;
import org.junit.Test;

import static org.jboss.installer.validators.PasswordSecurityValidator.PASSWORD_ANY_ALPHABETIC_KEY;
import static org.jboss.installer.validators.PasswordSecurityValidator.PASSWORD_ANY_DIGIT_KEY;
import static org.jboss.installer.validators.PasswordSecurityValidator.PASSWORD_ANY_NON_ALPHA_NUM_KEY;
import static org.jboss.installer.validators.PasswordSecurityValidator.PASSWORD_LENGTH_KEY;
import static org.jboss.installer.validators.PasswordSecurityValidator.USERNAME_PASSWORD_MATCH_KEY;

public class PasswordSecurityValidatorTest {

    public static String USERNAME = "username";
    public static String SHORT_PASSWORD = "short";
    public static String SECURE_PASSWORD = "us3rn&me_4";
    public static String NO_DIGITS_PASSWORD = "no_digits";
    public static String ONLY_ALPHA_CHARS_PASSWORD = "0nonAlphaChars";

    private final PasswordSecurityValidator validator = new PasswordSecurityValidator(new MockLanguageUtils());

    @Test
    public void PasswordLengthTest() {
        Assert.assertEquals(PASSWORD_LENGTH_KEY, validator.passwordSecurityCheck(USERNAME, SHORT_PASSWORD).getMessage());
    }

    @Test
    public void PasswordDigitTest() {
        Assert.assertEquals(PASSWORD_ANY_DIGIT_KEY, validator.passwordSecurityCheck(USERNAME, NO_DIGITS_PASSWORD).getMessage());
    }

    @Test
    public void PasswordNonAlphaCharTest() {
        Assert.assertEquals(PASSWORD_ANY_NON_ALPHA_NUM_KEY, validator.passwordSecurityCheck(USERNAME, ONLY_ALPHA_CHARS_PASSWORD).getMessage());
    }

    @Test
    public void PasswordMatchesUsernameTest() {
        Assert.assertEquals(USERNAME_PASSWORD_MATCH_KEY, validator.passwordSecurityCheck(SECURE_PASSWORD, SECURE_PASSWORD).getMessage());
    }

    @Test
    public void SecurePasswordTest() {
        Assert.assertNull(validator.passwordSecurityCheck(USERNAME, SECURE_PASSWORD).getMessage());
    }

    @Test
    public void noAlphabeticCharacterTest() {
        Assert.assertEquals(PASSWORD_ANY_ALPHABETIC_KEY, validator.passwordSecurityCheck(USERNAME, "1234568*").getMessage());
    }
}
