/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task.impl;

import org.jboss.installer.postinstall.PostInstallTask;
import org.jboss.installer.postinstall.PostInstallTaskImpl;
import org.jboss.installer.postinstall.TaskMapper;

public class TaskMapperImpl implements TaskMapper {

    public PostInstallTaskImpl map(PostInstallTask postInstallTask) {
        switch (postInstallTask) {
            case AddAdminUser:
                return new AddAdminUserTask();
            case InstallCredentialStore:
                return new CredentialStoreInstallTask();
            case AddDatasource:
                return new DatasourceTask();
            case EnableHttpsApplication:
                return new HttpsApplicationEnableTask();
            case EnableHttpsAdmin:
                return new HttpsEnableTask();
            case EnableIpv6:
                return new Ipv6EnabledTask();
            case UpdateJBossCliPort:
                return new JBossCliPortUpdaterTask();
            case AddJDBCDriverModule:
                return new JDBCDriverModuleTask();
            case InstallJDBCDriver:
                return new JDBCDriverTask();
            case SetJsfDefaultLibrary:
                return new JsfDefaultLibraryTask();
            case AddJsfLibrary:
                return new JsfLibraryTask();
            case SetupLDAPManagementAuth:
                return new LDAPSetupTask();
            case ChangeLoggingLevel:
                return new LoggingLevelsTask();
            case ChangePortConfiguration:
                return new PortConfigurationTask();
            case AddQuickstarts:
                return new QuickstartsTask();
            case AddSecurityDomain:
                return new SecurityDomainTask();
            default:
                throw new IllegalArgumentException("Unable to find implementation of task " + postInstallTask.getName());
        }
    }
}
