/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.panels.frame;

import org.jboss.installer.common.FontResources;
import org.jboss.installer.common.UiResources;
import org.jboss.installer.core.Screen;
import org.jboss.installer.panels.ScrollablePanel;
import org.jboss.installer.panels.StableScrollPaneLayout;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class ContentPanel extends JPanel {

    public ContentPanel() {
        initPanel();
    }

    public void displayScreen(Screen screen) {
        final JPanel titlePanel = createScreenTitle(screen.getTitle());

        this.removeAll();

        GridBagConstraints c = UiResources.initializeConstraints();
        c.insets = new Insets(20,20,20,20);
        this.add(titlePanel, c);

        c.fill = GridBagConstraints.BOTH;
        c.insets = new Insets(0,20,0,20);
        c.weighty = 1.0;   //request any extra vertical space
        c.gridy = 2;       //third row
        final JComponent screenContent = wrapInScrollPane(screen.getContent());
        screenContent.setName("ScreenContentPanel");
        this.add(screenContent, c);

        this.revalidate();
        this.repaint();
    }

    private JComponent wrapInScrollPane(JPanel content) {
        final ScrollablePanel scrollablePanel = new ScrollablePanel(new BorderLayout());
        scrollablePanel.add(content, BorderLayout.CENTER);
        final JScrollPane scrollPane = new JScrollPane(scrollablePanel);
        scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setLayout(new StableScrollPaneLayout());
        scrollPane.setBackground(Color.WHITE);

        return scrollPane;
    }

    private JPanel createScreenTitle(String screenTitle) {
        final JPanel titlePanel = new JPanel();
        titlePanel.setName("ScreenTitlePanel");
        titlePanel.setLayout(new BoxLayout(titlePanel, BoxLayout.X_AXIS));
        final JLabel title = new JLabel(screenTitle, SwingConstants.LEFT);
        title.setFont(FontResources.getOpenSansLight());
        titlePanel.add(title);
        return titlePanel;
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
    }
}
