/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.Screen;

import java.util.Arrays;

public class DomainFullHaPortConfigurationScreen extends CustomPortConfigurationScreen{

    public static final String NAME = "DomainFullHaPortConfigurationScreen";
    public static final String SIDE_NAV_NAME_KEY = "port.config.domain.full.ha.side_nav_name";
    public static final String CONFIG_NAME = "domain-full-ha";

    public DomainFullHaPortConfigurationScreen(Screen parent, LanguageUtils langUtils, boolean isActive) {
        super(parent, langUtils, isActive);
        properties = Arrays.asList(AJP_KEY, HTTP_KEY, HTTPS_KEY, IIOP_KEY, IIOP_SSL_KEY,
                JGROUPS_MPING_ADDRESS_KEY, JGROUPS_MPING_MCAST_PORT_KEY, JGROUPS_TCP_KEY,
                JGROUPS_TCP_FD_KEY, JGROUPS_UDP_KEY, JGROUPS_UDP_ADDRESS_KEY,
                JGROUPS_UDP_MCAST_PORT_KEY, JGROUPS_UDP_FD_KEY, MODCLUSTER_ADDRESS_KEY, MODCLUSTER_MCAST_PORT_KEY,
                TXN_RECOVERY_ENVIRONMENT_KEY, TXN_STATUS_MANAGER_KEY);
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSideNavName() {
        return langUtils.getString(SIDE_NAV_NAME_KEY);
    }

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }
}
