/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task.utils;

import org.jboss.dmr.ModelNode;
import org.jboss.installer.postinstall.task.CredentialStoreConfig;

import java.util.Optional;

public class CredentialStoreUtil {

    public static ModelNode addCredReference(ModelNode modelNode, Optional<CredentialStoreConfig> storeConfig, String alias, String password, String refNode) {
        final ModelNode credRefNode = modelNode.get(refNode);
        if (storeConfig.isPresent()) {
            credRefNode.get("alias").set(alias);
            credRefNode.get("store").set(storeConfig.get().getStoreName());
        } else {
            credRefNode.get("clear-text").set(password);
        }
        return credRefNode;
    }
}
