/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task.impl;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.postinstall.TaskPrinter;
import org.jboss.installer.postinstall.task.NoopPrinter;
import org.jboss.installer.test.utils.TestServer;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

import static org.junit.Assert.assertTrue;

public class AddAdminUserTaskTest {

    @ClassRule
    public static ExternalResource testServer = new TestServer();

    private TaskPrinter printer = new NoopPrinter();

    @Test
    public void addAdminUser() throws Exception {
        final InstallationData installationData = new InstallationData();
        installationData.setTargetFolder(TestServer.TARGET_PATH);
        installationData.setAdminUsername("admin");
        installationData.setPassword("test");

        new AddAdminUserTask().applyToInstallation(installationData, printer);

        assertAdminUserInConfigFile("standalone");
        assertAdminUserInConfigFile("domain");
    }

    private void assertAdminUserInConfigFile(String mode) throws IOException {
        final List<String> lines = Files.readAllLines(TestServer.TARGET_PATH.resolve(mode).resolve("configuration").resolve("mgmt-users.properties"));
        assertTrue(lines.stream().anyMatch(line->line.equals("admin=a2b659c61f05f64a7804135a4855b62b")));
    }

}
