/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPCLassPoolSearchStrategy;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.IsLocalResourcePlugin;
import org.jboss.aop.classpool.IsLocalResourcePluginFactoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassPool
extends AOPClassPool {
    private IsLocalResourcePlugin isLocalResourcePlugin;

    public BaseClassPool(ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository) {
        super(cl, parent, repository);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " isLocalResourcePlugin:" + this.isLocalResourcePlugin));
        }
    }

    public BaseClassPool(ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository, Class<? extends AOPCLassPoolSearchStrategy> searchStrategy) {
        super(cl, parent, repository, searchStrategy);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " isLocalResourcePlugin:" + this.isLocalResourcePlugin));
        }
    }

    public CtClass createCtClass(String classname, boolean useCache) {
        CtClass clazz = super.createCtClass(classname, useCache);
        if (clazz != null) {
            this.lockInCache(clazz);
        }
        return clazz;
    }

    protected CtClass createParentCtClass(String classname, boolean useCache, boolean trace) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BaseClassPool) {
            return ((AOPClassPool)this.parent).createCtClass(classname, useCache);
        }
        return this.plainParentGet(classname);
    }

    private CtClass plainParentGet(String classname) {
        try {
            return this.parent.get(classname);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public ClassPool getParent() {
        return this.parent;
    }

    protected boolean isLocalClassLoaderResource(String classResourceName) {
        return this.isLocalResourcePlugin.isMyResource(classResourceName);
    }

    public final CtClass get(String classname) throws NotFoundException {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " initiating get of " + classname));
        }
        CtClass clazz = super.get(classname);
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " completed get of " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
        }
        return clazz;
    }

    public CtClass get0(String classname, boolean useCache) throws NotFoundException {
        return super.get0(classname, useCache);
    }

    public void close() {
        super.close();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " closing"));
        }
    }
}

