/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PhoneHandler
extends AbstractHandler {
    public static final String TAG_NAME = "phone";

    protected PhoneHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        Phone obj = new Phone();
        String useType = element.getAttribute("useType");
        if (useType != null && useType.trim().length() > 0) {
            obj.setUseType(useType);
        }
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String phoneValue;
        Phone phone = (Phone)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String useType = phone.getUseType();
        if (useType != null && useType.trim().length() > 0) {
            element.setAttribute("useType", useType);
        }
        if ((phoneValue = phone.getValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(phoneValue));
        }
        parent.appendChild(element);
    }
}

