/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.InternalConstant;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoReference;
import org.jboss.cache.pojo.util.ObjectUtil;

public class InternalHelper {
    private static Log log = LogFactory.getLog((String)InternalHelper.class.getName());
    private Cache<Object, Object> cache;
    private PojoCache pcache;

    InternalHelper(PojoCache pcache) {
        this.cache = pcache.getCache();
        this.pcache = pcache;
    }

    PojoInstance getPojoInstance(Fqn fqn) throws CacheException {
        return (PojoInstance)this.get(fqn, "POJOCache.PojoInstance", true);
    }

    PojoReference getPojoReference(Fqn fqn, String field) throws CacheException {
        if (field == null) {
            field = "POJOCache.PojoReference";
        }
        return (PojoReference)this.get(fqn, field, true);
    }

    PojoReference getPojoReference(Fqn fqn) throws CacheException {
        return this.getPojoReference(fqn, null);
    }

    static PojoInstance initializeAopInstance(Reference reference) {
        PojoInstance pojoInstance = new PojoInstance();
        pojoInstance.incrementRefCount(reference);
        return pojoInstance;
    }

    int incrementRefCount(Fqn originalFqn, Reference reference) throws CacheException {
        PojoInstance pojoInstance = this.getPojoInstance(originalFqn);
        if (pojoInstance == null) {
            throw new PojoCacheException("InternalDelegate.incrementRefCount(): null pojoReference for fqn: " + originalFqn);
        }
        int count = pojoInstance.incrementRefCount(reference);
        this.put(originalFqn, "POJOCache.PojoInstance", pojoInstance);
        return count;
    }

    Object get(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, false);
    }

    private Object get(Fqn fqn, Object key, boolean gravitate) throws CacheException {
        if (gravitate && this.pcache.getThreadContext().isGravitationEnabled()) {
            this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
            Object obj = this.cache.get(fqn, key);
            this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(false);
            return obj;
        }
        return this.cache.get(fqn, key);
    }

    private void put(Fqn fqn, Object key, Object value) throws CacheException {
        this.cache.put(fqn, key, value);
    }

    void put(Fqn fqn, Map map) throws CacheException {
        this.cache.put(fqn, map);
    }

    int decrementRefCount(Fqn originalFqn, Reference reference) throws CacheException {
        PojoInstance pojoInstance = this.getPojoInstance(originalFqn);
        if (pojoInstance == null) {
            throw new PojoCacheException("InternalDelegate.decrementRefCount(): null pojoReference.");
        }
        int count = pojoInstance.decrementRefCount(reference);
        if (count < -1) {
            throw new PojoCacheException("InternalDelegate.decrementRefCount(): null pojoReference.");
        }
        this.put(originalFqn, "POJOCache.PojoInstance", pojoInstance);
        return count;
    }

    static boolean isReferenced(PojoInstance pojoInstance) {
        return pojoInstance.getRefCount() > 0;
    }

    Object getPojo(Fqn fqn, String field) throws CacheException {
        PojoReference pojoReference = this.getPojoReference(fqn, field);
        Fqn realFqn = null;
        if (pojoReference != null) {
            realFqn = pojoReference.getFqn();
        } else {
            if (field != null) {
                return null;
            }
            realFqn = fqn;
        }
        PojoInstance pojoInstance = this.getPojoInstance(realFqn);
        if (pojoInstance == null) {
            return null;
        }
        return pojoInstance.get();
    }

    void setPojo(Fqn fqn, Object pojo) throws CacheException {
        PojoInstance pojoInstance = this.getPojoInstance(fqn);
        if (pojoInstance == null) {
            pojoInstance = new PojoInstance();
            this.put(fqn, "POJOCache.PojoInstance", pojoInstance);
        }
        pojoInstance.set(pojo);
    }

    static boolean isMultipleReferenced(PojoInstance pojoInstance) {
        return pojoInstance.getRefCount() > 0;
    }

    static void setPojo(PojoInstance pojoInstance, Object pojo) {
        pojoInstance.set(pojo);
    }

    void setPojo(Fqn fqn, Object pojo, PojoInstance pojoInstance) throws CacheException {
        if (pojoInstance == null) {
            pojoInstance = new PojoInstance();
            this.put(fqn, "POJOCache.PojoInstance", pojoInstance);
        }
        pojoInstance.set(pojo);
    }

    void putPojoReference(Fqn fqn, PojoReference pojoReference) throws CacheException {
        this.putPojoReference(fqn, pojoReference, "POJOCache.PojoReference");
    }

    void putPojoReference(Fqn fqn, PojoReference pojoReference, String field) throws CacheException {
        if (field == null) {
            field = "POJOCache.PojoReference";
        }
        this.put(fqn, field, pojoReference);
    }

    void putAopClazz(Fqn fqn, Class clazz) throws CacheException {
        this.put(fqn, "__jboss:internal:class__", clazz);
    }

    static void putAopClazz(Class clazz, Map map) {
        map.put("__jboss:internal:class__", clazz);
    }

    Class peekAopClazz(Fqn fqn) throws CacheException {
        return (Class)this.get(fqn, "__jboss:internal:class__");
    }

    void removeInternalAttributes(Fqn fqn) throws CacheException {
        this.cache.remove(fqn, (Object)"POJOCache.PojoInstance");
        this.cache.remove(fqn, (Object)"__jboss:internal:class__");
    }

    void cleanUp(Fqn fqn, String field) throws CacheException {
        if (field != null) {
            this.cache.remove(fqn, (Object)field);
            return;
        }
        if (this.cache.getRoot().getChild(fqn).getChildren().size() == 0) {
            this.cache.removeNode(fqn);
        } else {
            this.cache.getRoot().getChild(fqn).clearData();
            if (log.isTraceEnabled()) {
                log.trace((Object)("cleanup(): fqn: " + fqn + " is not empty. That means it has sub-pojos. Will not remove node"));
            }
        }
    }

    String createIndirectFqn(String fqn) throws CacheException {
        String indirectFqn = InternalHelper.getIndirectFqn(fqn);
        Fqn internalFqn = this.getInternalFqn(fqn);
        this.put(internalFqn, indirectFqn, fqn);
        return indirectFqn;
    }

    private Fqn getInternalFqn(String fqn) {
        if (fqn == null || fqn.length() == 0) {
            throw new IllegalStateException("InternalDelegate.getInternalFqn(). fqn is either null or empty!");
        }
        String indirectFqn = InternalHelper.getIndirectFqn(fqn);
        return new Fqn(InternalConstant.JBOSS_INTERNAL_MAP, new Object[]{indirectFqn});
    }

    static String getIndirectFqn(String fqn) {
        return ObjectUtil.getIndirectFqn(fqn);
    }

    void removeIndirectFqn(String oldFqn) throws CacheException {
        String indirectFqn = InternalHelper.getIndirectFqn(oldFqn);
        this.cache.remove(this.getInternalFqn(oldFqn), (Object)indirectFqn);
    }

    void setIndirectFqn(String oldFqn, String newFqn) throws CacheException {
        String indirectFqn = InternalHelper.getIndirectFqn(oldFqn);
        Fqn tmpFqn = this.getInternalFqn(oldFqn);
        this.put(tmpFqn, indirectFqn, newFqn);
    }

    void updateIndirectFqn(Fqn originalFqn, Fqn newFqn) throws CacheException {
        this.put(this.getInternalFqn(originalFqn.toString()), InternalHelper.getIndirectFqn(originalFqn.toString()), newFqn.toString());
    }

    private String getRefFqnFromAlias(String aliasFqn) throws CacheException {
        return (String)this.get(this.getInternalFqn(aliasFqn), aliasFqn, true);
    }

    public static boolean isInternalNode(Fqn fqn) {
        return fqn.isChildOrEquals(InternalConstant.JBOSS_INTERNAL);
    }

    public boolean lockPojo(Fqn id) throws CacheException {
        int RETRY = 5;
        if (log.isTraceEnabled()) {
            log.trace((Object)("lockPojo(): id:" + id));
        }
        boolean isNeeded = true;
        int retry = 0;
        while (isNeeded) {
            try {
                this.cache.put(id, (Object)"POJOCache.LOCK", (Object)"LOCK");
                isNeeded = false;
            }
            catch (UpgradeException upe) {
                log.warn((Object)("lockPojo(): can't upgrade the lock during lockPojo. Will re-try. id: " + id + " retry times: " + retry));
                if (retry++ > 5) {
                    return false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
        }
        return true;
    }
}

