/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advisor;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.aop.microcontainer.annotations.DisableAOP;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.currentinvocation.CurrentInvocationInterceptor;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DefaultEjbEncFactory;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContextFactory;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.EjbEncFactory;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.Pool;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.aop.BeanContainer;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.injection.InjectionInvocation;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.direct.DirectContainer;
import org.jboss.ejb3.interceptors.direct.IndirectContainer;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEComponentHelper;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.pool.PoolFactory;
import org.jboss.ejb3.pool.PoolFactoryRegistry;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBHandler;
import org.jboss.injection.EJBInjectionContainer;
import org.jboss.injection.EncInjector;
import org.jboss.injection.ExtendedInjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiInjectHandler;
import org.jboss.injection.PersistenceContextHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.jca.spi.ComponentStack;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.naming.Util;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DisableAOP
public abstract class EJBContainer
implements Container,
IndirectContainer<EJBContainer, DirectContainer<EJBContainer>>,
EJBInjectionContainer,
ExtendedInjectionContainer,
JavaEEComponent {
    private static final Logger log = Logger.getLogger(EJBContainer.class);
    private String name;
    private BeanContainer beanContainer;
    private DirectContainer<EJBContainer> directContainer;
    protected EjbEncFactory encFactory = new DefaultEjbEncFactory();
    protected org.jboss.ejb3.pool.Pool pool;
    protected String ejbName;
    protected ObjectName objectName;
    protected int defaultConstructorIndex;
    protected String beanClassName;
    private Class<?> beanClass;
    protected ClassLoader classloader;
    protected List<Injector> injectors = new ArrayList<Injector>();
    protected Context enc;
    protected Hashtable initialContextProperties;
    protected Map<String, EncInjector> encInjectors = new HashMap<String, EncInjector>();
    protected JBossEnterpriseBeanMetaData xml;
    protected JBossAssemblyDescriptorMetaData assembly;
    protected Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    private HashMap<Class<?>, InterceptorInjector> interceptorInjectors = new HashMap();
    private Ejb3Deployment deployment;
    private DependencyPolicy dependencyPolicy;
    private String jaccContextId;
    protected InvocationStatistics invokeStats = new InvocationStatistics();
    private String partitionName;
    private List<Class<?>> businessInterfaces;
    private ThreadLocalStack<BeanContext<?>> currentBean = new ThreadLocalStack();
    protected boolean reinitialize = false;
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    private final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final Lock invocationLock = new SemaphoreLock(this.semaphore);
    private static final Interceptor[] currentInvocationStack = new Interceptor[]{new CurrentInvocationInterceptor()};
    private ComponentStack cachedConnectionManager;
    public static final String MANAGED_ENTITY_MANAGER_FACTORY = "ManagedEntityManagerFactory";
    public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";

    public EJBContainer(String name, Domain domain, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, Ejb3Deployment deployment, JBossEnterpriseBeanMetaData beanMetaData) throws ClassNotFoundException {
        assert (name != null) : "name is null";
        assert (deployment != null) : "deployment is null";
        this.name = name;
        this.deployment = deployment;
        this.beanClassName = beanClassName;
        this.classloader = cl;
        this.xml = beanMetaData;
        this.beanClass = this.classloader.loadClass(beanClassName);
        this.beanContainer = new BeanContainer(this);
        this.ejbName = ejbName;
        String on = this.createObjectName(ejbName);
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("failed to create object name for: " + on, e);
        }
        try {
            this.beanContainer.initialize(ejbName, domain, this.beanClass, beanMetaData, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize bean container ", e);
        }
        this.initialContextProperties = ctxProperties;
        try {
            Util.createSubcontext((Context)this.getEnc(), (String)"env");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.bindORB();
        this.bindEJBContext();
        this.dependencyPolicy = deployment.createDependencyPolicy(this);
    }

    private void bindEJBContext() {
        try {
            Reference ref = new Reference(EJBContext.class.getName(), EJBContextFactory.class.getName(), null);
            ref.add(new StringRefAddr("containerGuid", Ejb3Registry.guid(this)));
            ref.add(new StringRefAddr("containerClusterUid", Ejb3Registry.clusterUid(this)));
            ref.add(new StringRefAddr("isClustered", Boolean.toString(this.isClustered())));
            Util.rebind((Context)this.getEnc(), (String)"EJBContext", (Object)ref);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private void bindORB() {
        try {
            Util.rebind((Context)this.getEnc(), (String)"ORB", (Object)new LinkRef("java:/JBossCorbaORB"));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public boolean canResolveEJB() {
        return this.deployment.canResolveEJB();
    }

    @Override
    public abstract BeanContext<?> createBeanContext();

    @Override
    public String createObjectName(String ejbName) {
        return JavaEEComponentHelper.createObjectName(this.deployment, ejbName);
    }

    public Object createInterceptor(Class<?> interceptorClass) throws InstantiationException, IllegalAccessException {
        Object instance = interceptorClass.newInstance();
        InterceptorInjector interceptorInjector = this.interceptorInjectors.get(interceptorClass);
        assert (interceptorInjector != null) : "interceptorInjector not found for " + interceptorClass;
        interceptorInjector.inject(null, instance);
        return instance;
    }

    @Override
    public String createObjectName(String unitName, String ejbName) {
        return JavaEEComponentHelper.createObjectName(this.deployment, unitName, ejbName);
    }

    public void destroyBeanContext(org.jboss.ejb3.interceptors.container.BeanContext<?> ctx) {
    }

    @Deprecated
    public Advisor getAdvisor() {
        return this.beanContainer._getAdvisor();
    }

    @Deprecated
    public AnnotationRepository getAnnotations() {
        return this.beanContainer.getAnnotationRepository();
    }

    protected BeanContainer getBeanContainer() {
        return this.beanContainer;
    }

    public Class<?> getClazz() {
        return this.getBeanClass();
    }

    public static <C extends EJBContainer> C getEJBContainer(Advisor advisor) {
        try {
            return (C)((BeanContainer)((ManagedObjectAdvisor)advisor).getContainer()).getEJBContainer();
        }
        catch (ClassCastException e) {
            throw new ClassCastException(e.getMessage() + " using " + advisor);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void pushContext(BeanContext<?> beanContext) {
        this.currentBean.push(beanContext);
    }

    protected void pushEnc() {
        this.encFactory.pushEnc(this);
    }

    @Override
    public BeanContext<?> peekContext() {
        BeanContext<?> ctx = this.currentBean.get();
        assert (ctx != null) : "ctx is null";
        return ctx;
    }

    @Override
    public BeanContext<?> popContext() {
        return this.currentBean.pop();
    }

    protected void popEnc() {
        this.encFactory.popEnc(this);
    }

    public Environment getEnvironmentRefGroup() {
        return this.xml;
    }

    @Override
    public List<Injector> getInjectors() {
        return this.injectors;
    }

    public String getJaccContextId() {
        return this.jaccContextId;
    }

    public List<Method> getVirtualMethods() {
        return null;
    }

    public void setJaccContextId(String jaccContextId) {
        this.jaccContextId = jaccContextId;
    }

    @Override
    public VirtualFile getRootFile() {
        return this.getDeploymentUnit().getRootFile();
    }

    public List<Class<?>> getBusinessInterfaces() {
        if (this.businessInterfaces == null) {
            throw new IllegalStateException("businessInterfaces not yet initialized");
        }
        return this.businessInterfaces;
    }

    public String getDeploymentQualifiedName() {
        return this.objectName.getCanonicalName();
    }

    public String getDeploymentPropertyListString() {
        return this.objectName.getCanonicalKeyPropertyListString();
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.deployment.getDeploymentUnit();
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.beanContainer.isAnnotationPresent(annotationType);
    }

    public boolean isBusinessMethod(Method businessMethod) {
        for (Class<?> businessInterface : this.getBusinessInterfaces()) {
            for (Method method : businessInterface.getMethods()) {
                if (!EJBContainer.isCallable(method, businessMethod)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCallable(Method method, Method other) {
        if (method.getDeclaringClass().isAssignableFrom(other.getDeclaringClass()) && method.getName().equals(other.getName())) {
            Class<?>[] params2;
            if (!method.getReturnType().equals(other.getReturnType())) {
                return false;
            }
            Class<?>[] params1 = method.getParameterTypes();
            if (params1.length == (params2 = other.getParameterTypes()).length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMetadata() {
        Collection handlers = this.deployment.getHandlers();
        if (handlers == null) {
            handlers = new ArrayList<InjectionHandler<Environment>>();
            handlers.add(new EJBHandler());
            handlers.add(new DependsHandler());
            handlers.add(new JndiInjectHandler());
            handlers.add(new PersistenceContextHandler());
            handlers.add(new PersistenceUnitHandler());
            handlers.add(new ResourceHandler());
            handlers.add(new WebServiceRefHandler());
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classloader);
        try {
            Class<?> clazz;
            for (InjectionHandler<Environment> injectionHandler : handlers) {
                injectionHandler.loadXml((Environment)this.xml, this);
            }
            Map<AccessibleObject, Injector> tmp = InjectionUtil.processAnnotations(this, handlers, this.getBeanClass());
            this.injectors.addAll(tmp.values());
            for (Class<?> clazz2 : this.beanContainer.getInterceptorClasses()) {
                InterceptorMetaData interceptorMetaData = this.findInterceptor(clazz2);
                if (interceptorMetaData == null) continue;
                for (InjectionHandler<InterceptorMetaData> injectionHandler : handlers) {
                    injectionHandler.loadXml(interceptorMetaData, this);
                }
            }
            for (Class<?> clazz3 : this.beanContainer.getInterceptorClasses()) {
                Map<AccessibleObject, Injector> injections = InjectionUtil.processAnnotations(this, handlers, clazz3);
                InterceptorInjector injector = new InterceptorInjector(injections);
                this.interceptorInjectors.put(clazz3, injector);
            }
            if (this.xml != null && this.xml.getServiceReferences() != null) {
                for (ServiceReferenceMetaData serviceReferenceMetaData : this.xml.getServiceReferences()) {
                }
            }
            this.checkForDuplicateLocalAndRemoteInterfaces();
            for (Class<?> clazz4 : this.getBusinessInterfaces()) {
                ((JBoss5DependencyPolicy)this.getDependencyPolicy()).addSupply(clazz4);
            }
            Class<?> clazz5 = ProxyFactoryHelper.getLocalHomeInterface(this);
            if (clazz5 != null) {
                ((JBoss5DependencyPolicy)this.getDependencyPolicy()).addSupply(clazz5);
            }
            if ((clazz = ProxyFactoryHelper.getRemoteHomeInterface(this)) != null) {
                ((JBoss5DependencyPolicy)this.getDependencyPolicy()).addSupply(clazz);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void checkForDuplicateLocalAndRemoteInterfaces() throws EJBException {
        String issue = "[EJBTHREE-1025]";
        Local local = (Local)this.resolveAnnotation(Local.class);
        Remote remote = (Remote)this.resolveAnnotation(Remote.class);
        if (local == null || remote == null) {
            return;
        }
        if (local.value().length < 1 && local.value().length < 1) {
            throw new EJBException("Cannot designate both " + Local.class.getName() + " and " + Remote.class.getName() + " annotations without 'value' attribute on " + this.getEjbName() + ". " + issue);
        }
        for (Class localClass : local.value()) {
            for (Class remoteClass : remote.value()) {
                if (!localClass.equals(remoteClass)) continue;
                throw new EJBException("Cannot designate " + localClass.getName() + " as both " + Local.class.getName() + " and " + Remote.class.getName() + " on " + this.getEjbName() + ". " + issue);
            }
        }
    }

    public JBossEnterpriseBeanMetaData getXml() {
        return this.xml;
    }

    public JBossAssemblyDescriptorMetaData getAssemblyDescriptor() {
        return this.assembly;
    }

    @Deprecated
    public void setAssemblyDescriptor(JBossAssemblyDescriptorMetaData assembly) {
        this.assembly = assembly;
    }

    protected abstract List<Class<?>> resolveBusinessInterfaces();

    public InterceptorInfoRepository getInterceptorRepository() {
        throw new RuntimeException("invalid");
    }

    @Override
    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    public ComponentStack getCachedConnectionManager() {
        return this.cachedConnectionManager;
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public InitialContext getInitialContext() {
        try {
            return InitialContextFactory.getInitialContext(this.initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    @Override
    public Context getEnc() {
        if (this.enc == null) {
            this.enc = this.encFactory.getEnc(this);
        }
        return this.enc;
    }

    @Override
    public Hashtable getInitialContextProperties() {
        return this.initialContextProperties;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public org.jboss.ejb3.pool.Pool getPool() {
        return this.pool;
    }

    public String getPartitionName() {
        if (this.partitionName == null) {
            this.findPartitionName();
        }
        return this.partitionName;
    }

    protected Object construct() {
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void reinitialize() {
        this.beanContainer.reinitializeAdvisor();
        this.bindEJBContext();
        this.reinitialize = false;
    }

    @Override
    public void create() throws Exception {
        this.blockInvocations();
    }

    @Override
    public void start() throws Exception {
        this.lockedStart();
        this.allowInvocations();
    }

    protected void lockedStart() throws Exception {
        if (this.reinitialize) {
            this.reinitialize();
        }
        this.initializePool();
        for (EncInjector injector : this.encInjectors.values()) {
            injector.inject(this);
        }
        Injector[] injectors2 = this.injectors.toArray(new Injector[this.injectors.size()]);
        if (this.pool != null) {
            this.pool.setInjectors(injectors2);
        }
        this.findPartitionName();
        log.info((Object)("STARTED EJB: " + this.beanClass.getName() + " ejbName: " + this.ejbName));
    }

    @Override
    public void stop() throws Exception {
        this.blockInvocations();
        this.lockedStop();
    }

    protected void lockedStop() throws Exception {
        this.reinitialize = true;
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
        this.injectors = new ArrayList<Injector>();
        this.encInjectors = new HashMap<String, EncInjector>();
        InitialContextFactory.close(this.enc, this.initialContextProperties);
        this.enc = null;
        log.info((Object)("STOPPED EJB: " + this.beanClass.getName() + " ejbName: " + this.ejbName));
    }

    @Override
    public void destroy() throws Exception {
        this.encFactory.cleanupEnc(this);
    }

    @Override
    public <T> T getSecurityManager(Class<T> type) {
        try {
            InitialContext ctx = this.getInitialContext();
            SecurityDomain securityAnnotation = (SecurityDomain)this.resolveAnnotation(SecurityDomain.class);
            if (securityAnnotation != null && securityAnnotation.value().length() > 0) {
                return (T)SecurityDomainManager.getSecurityManager((String)securityAnnotation.value(), (InitialContext)ctx);
            }
            return null;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Method getTimeoutCallback(NamedMethodMetaData timeoutMethodMetaData, Class<?> beanClass) {
        JBossEnterpriseBeanMetaData metaData = this.xml;
        if (metaData != null && timeoutMethodMetaData != null) {
            String methodName = timeoutMethodMetaData.getMethodName();
            try {
                return beanClass.getMethod(methodName, Timer.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method " + methodName + "(javax.ejb.Timer timer) found on bean " + this.ejbName, e);
            }
        }
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                return TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        if (metaData != null && metaData.getEjbJarMetaData().isMetadataComplete()) {
            return null;
        }
        for (Method method : beanClass.getMethods()) {
            if (this.getAnnotation(Timeout.class, method) == null) continue;
            if (Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Timer.class)) {
                return method;
            }
            throw new RuntimeException("@Timeout method " + method + " must have signature: void <METHOD>(javax.ejb.Timer timer) (EJB3 18.2.2)");
        }
        return null;
    }

    protected void initializePool() throws Exception {
        Pool poolAnnotation = this.getAnnotation(Pool.class);
        if (poolAnnotation == null) {
            throw new IllegalStateException("No pool annotation");
        }
        String registeredPoolName = poolAnnotation.value();
        if (registeredPoolName == null || registeredPoolName.trim().equals("")) {
            registeredPoolName = "ThreadlocalPool";
        }
        int maxSize = poolAnnotation.maxSize();
        long timeout = poolAnnotation.timeout();
        PoolFactoryRegistry registry = this.deployment.getPoolFactoryRegistry();
        PoolFactory factory = registry.getPoolFactory(registeredPoolName);
        this.pool = factory.createPool();
        this.pool.initialize(this, maxSize, timeout);
        this.resolveInjectors();
        this.pool.setInjectors(this.injectors.toArray(new Injector[this.injectors.size()]));
    }

    @Override
    public void injectBeanContext(BeanContext<?> beanContext) {
        try {
            if (this.injectors == null) {
                return;
            }
            Advisor advisor = this.getAdvisor();
            for (Injector injector : this.injectors) {
                InjectionInvocation invocation = new InjectionInvocation(beanContext, injector, currentInvocationStack);
                invocation.setAdvisor(advisor);
                invocation.setTargetObject(beanContext.getInstance());
                invocation.invokeNext();
            }
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected void invokeCallback(BeanContext<?> beanContext, Class<? extends Annotation> callbackAnnotationClass) {
        this.getBeanContainer().invokeCallback(beanContext, callbackAnnotationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePostConstruct(BeanContext<?> beanContext) {
        AllowedOperationsAssociation.pushInMethodFlag((int)AllowedOperationsAssociation.IN_EJB_CREATE);
        try {
            this.invokeCallback(beanContext, PostConstruct.class);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    @Override
    @Deprecated
    public void invokePostConstruct(BeanContext beanContext, Object[] params) {
        this.invokePostConstruct(beanContext);
    }

    @Override
    public void invokePreDestroy(BeanContext beanContext) {
        this.invokeCallback(beanContext, PreDestroy.class);
    }

    @Override
    public void invokePostActivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokePrePassivate(BeanContext beanContext) {
        throw new RuntimeException("PrePassivate not implemented for container");
    }

    @Override
    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInjectors() throws Exception {
        this.pushEnc();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Util.rebind((Context)this.getEnc(), (String)"UserTransaction", (Object)new UserTransactionImpl());
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind user transaction for ejb name " + this.ejbName + " into JNDI under jndiName: " + this.getEnc().getNameInNamespace() + "/" + "UserTransaction");
                namingException.setRootCause(e);
                throw namingException;
            }
            try {
                Util.rebind((Context)this.getEnc(), (String)"TransactionSynchronizationRegistry", (Object)new LinkRef("java:TransactionSynchronizationRegistry"));
                log.debug((Object)"Linked java:comp/TransactionSynchronizationRegistry to JNDI name: java:TransactionSynchronizationRegistry");
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind TransactionSynchronizationRegistry for ejb name " + this.ejbName + " into JNDI under jndiName: " + this.getEnc().getNameInNamespace() + "/" + "TransactionSynchronizationRegistry");
                namingException.setRootCause(e);
                throw namingException;
            }
        }
        finally {
            this.popEnc();
        }
    }

    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, Timeout.class};
    }

    private InterceptorMetaData findInterceptor(Class<?> interceptorClass) {
        if (this.xml == null) {
            return null;
        }
        JBossMetaData ejbJarMetaData = this.xml.getEjbJarMetaData();
        if (ejbJarMetaData == null) {
            return null;
        }
        InterceptorsMetaData interceptors = ejbJarMetaData.getInterceptors();
        if (interceptors == null) {
            return null;
        }
        for (InterceptorMetaData interceptorMetaData : interceptors) {
            if (!interceptorMetaData.getInterceptorClass().equals(interceptorClass.getName())) continue;
            return interceptorMetaData;
        }
        return null;
    }

    protected void findPartitionName() {
        Clustered clustered = this.getAnnotation(Clustered.class);
        if (clustered == null) {
            this.partitionName = null;
            return;
        }
        String value = clustered.partition();
        try {
            String replacedValue = StringPropertyReplacer.replaceProperties((String)value);
            if (value != replacedValue) {
                log.debug((Object)("Replacing @Clustered partition attribute " + value + " with " + replacedValue));
                value = replacedValue;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to replace @Clustered partition attribute " + value + ". Caused by " + e.getClass() + " " + e.getMessage()));
        }
        this.partitionName = value;
    }

    public <T> T getBusinessObject(BeanContext<?> beanContext, Class<T> businessInterface) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    public Object getInvokedBusinessInterface(BeanContext beanContext) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    protected Object getInvokedInterface(Method method) {
        Local localAnnotation;
        Remote remoteAnnotation = (Remote)this.resolveAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            Class[] remotes = remoteAnnotation.value();
            for (int i = 0; i < remotes.length; ++i) {
                try {
                    remotes[i].getMethod(method.getName(), method.getParameterTypes());
                    return remotes[i];
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        if ((localAnnotation = (Local)this.resolveAnnotation(Local.class)) != null) {
            Class[] locals = localAnnotation.value();
            for (int i = 0; i < locals.length; ++i) {
                Method[] interfaceMethods = locals[i].getMethods();
                for (int j = 0; j < interfaceMethods.length; ++j) {
                    if (!interfaceMethods[j].equals(method)) continue;
                    return locals[i];
                }
            }
        }
        return null;
    }

    private Class loadPublicAnnotation(String annotation) {
        try {
            Class<?> ann = this.classloader.loadClass(annotation);
            if (!ann.isAnnotation()) {
                return null;
            }
            Retention retention = ann.getAnnotation(Retention.class);
            if (retention != null && retention.value() == RetentionPolicy.RUNTIME) {
                return ann;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String resolveEJB(String link, Class<?> beanInterface, String mappedName) {
        return this.deployment.resolveEJB(link, beanInterface, mappedName);
    }

    public Container resolveEjbContainer(String link, Class businessIntf) {
        return this.deployment.getEjbContainer(link, businessIntf);
    }

    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.deployment.getEjbContainer(businessIntf);
    }

    @Override
    public String resolveMessageDestination(String link) {
        return this.deployment.resolveMessageDestination(link);
    }

    @Override
    public String resolvePersistenceUnitSupplier(String unitName) {
        return this.getDeployment().resolvePersistenceUnitSupplier(unitName);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (this.getAnnotations().isDisabled(annotationType)) {
            return null;
        }
        return this.beanContainer.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        return this.beanContainer.getAnnotation(clazz, annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        return this.beanContainer.getAnnotation(annotationType, clazz, method);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        if (this.getAnnotations().isDisabled((Member)method, annotationType)) {
            return null;
        }
        return this.beanContainer.getAnnotation(annotationType, method);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        return this.beanContainer.getAnnotation(annotationType, clazz, field);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return this.beanContainer.getAnnotation(annotationType, field);
    }

    public Object resolveAnnotation(Class annotationType) {
        return this.getAnnotation(annotationType);
    }

    public Object resolveAnnotation(Field field, Class annotationType) {
        return this.getAnnotation(annotationType, field);
    }

    public Object resolveAnnotation(Method method, Class annotationType) {
        return this.getAnnotation(annotationType, method);
    }

    public Object resolveAnnotation(Method m, Class[] annotationChoices) {
        Object value = null;
        int i = 0;
        while (value == null && i < annotationChoices.length) {
            value = this.resolveAnnotation(m, annotationChoices[i++]);
        }
        return value;
    }

    @Override
    public String getIdentifier() {
        return this.getEjbName();
    }

    @Override
    public String getDeploymentDescriptorType() {
        return "ejb-jar.xml";
    }

    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        return this.deployment.getEjbJndiName(businessInterface);
    }

    public String getEjbJndiName(String link, Class businessInterface) {
        return this.deployment.getEjbJndiName(link, businessInterface);
    }

    @Override
    public InvocationStatistics getInvokeStats() {
        return this.invokeStats;
    }

    @Deprecated
    protected MethodInfo getMethodInfo(Method method) {
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = this.getAdvisor().getMethodInfo(hash);
        if (info == null) {
            throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
        }
        return info;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public JavaEEModule getModule() {
        return this.deployment;
    }

    @Override
    public abstract boolean hasJNDIBinding(String var1);

    public void instantiated() {
        this.businessInterfaces = this.resolveBusinessInterfaces();
        this.beanContainer.reinitializeAdvisor();
    }

    @Inject
    public void setCachedConnectionManager(ComponentStack ccm) {
        this.cachedConnectionManager = ccm;
    }

    public void setDirectContainer(DirectContainer<EJBContainer> container) {
        this.directContainer = container;
    }

    protected Method getNonBridgeMethod(Method bridgeMethod) {
        Method[] methods;
        Class<?> clazz = bridgeMethod.getDeclaringClass();
        for (Method method : methods = clazz.getMethods()) {
            if (method.isBridge() || method.getParameterTypes().length != bridgeMethod.getParameterTypes().length) continue;
            return method;
        }
        return bridgeMethod;
    }

    public Lock getInvocationLock() {
        return this.invocationLock;
    }

    @Inject
    public void setTransactionManager(TransactionManager tm) {
    }

    public String toString() {
        return this.getObjectName().getCanonicalName();
    }

    private void blockInvocations() throws InterruptedException {
        if (this.semaphore.tryAcquire()) {
            try {
                this.semaphore.acquire(0x7FFFFFFE);
            }
            catch (InterruptedException e) {
                this.semaphore.release();
                throw e;
            }
        }
    }

    private void allowInvocations() {
        if (!this.semaphore.tryAcquire()) {
            this.semaphore.release(Integer.MAX_VALUE);
        } else {
            this.semaphore.release();
        }
    }

    private static class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        SemaphoreLock(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void lock() {
            this.semaphore.acquireUninterruptibly();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.semaphore.acquire();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock() {
            return this.semaphore.tryAcquire();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(timeout, unit);
        }

        public void unlock() {
            this.semaphore.release();
        }
    }
}

