/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.StringMemberValue;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.Entity;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.annotation.Consumer;
import org.jboss.ejb3.annotation.Service;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossConsumerBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3AnnotationHandler
implements Ejb3Handler {
    private static final Logger log = Logger.getLogger(Ejb3AnnotationHandler.class);
    protected DeploymentUnit di;
    protected ClassFile cf;
    protected List<String> ejbNames = new ArrayList<String>();
    protected Class<?> ejbClass;
    protected String className;
    protected EJB_TYPE ejbType;
    protected Annotation annotation;
    protected AnnotationsAttribute visible;
    protected Hashtable ctxProperties;
    protected String defaultSLSBDomain;
    protected String defaultSFSBDomain;
    protected String defaultMDBDomain;
    protected String defaultServiceDomain;
    protected String defaultConsumerDomain;
    protected Ejb3Deployment deployment;

    public Ejb3AnnotationHandler(Ejb3Deployment deployment) {
        this.deployment = deployment;
        this.di = deployment.getDeploymentUnit();
        this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
        this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
        this.defaultMDBDomain = deployment.getDefaultMDBDomain();
        this.defaultServiceDomain = deployment.getDefaultServiceDomain();
        this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
    }

    public Ejb3AnnotationHandler(Ejb3Deployment deployment, ClassFile cf) {
        this.deployment = deployment;
        this.di = deployment.getDeploymentUnit();
        this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
        this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
        this.defaultMDBDomain = deployment.getDefaultMDBDomain();
        this.defaultServiceDomain = deployment.getDefaultServiceDomain();
        this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
        this.cf = cf;
        this.className = cf.getName();
        this.visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
    }

    private <M extends JBossEnterpriseBeanMetaData> M getEnterpriseBeanMetaData(Ejb3Deployment deployment, String ejbName, Class<M> enterpriseBeanMetaDataClass) {
        JBossMetaData ejbJarMetaData = deployment.getMetaData();
        if (ejbJarMetaData == null) {
            return null;
        }
        if (!ejbJarMetaData.isEJB3x()) {
            throw new IllegalStateException("Attempt to process non-EJB3.x EJB-JAR metadata as EJB3.x for deployment " + deployment.getName());
        }
        Object beanMetaData = deployment.getEnterpriseBeanMetaData(ejbName, enterpriseBeanMetaDataClass);
        if (beanMetaData == null) {
            log.warn((Object)("JBMETA-4: did not find any bean meta data for annotation bean " + ejbName + ", will create some"));
            try {
                beanMetaData = (JBossEnterpriseBeanMetaData)enterpriseBeanMetaDataClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException();
            }
            beanMetaData.setEjbName(ejbName);
            JBossEnterpriseBeansMetaData enterpriseBeans = ejbJarMetaData.getEnterpriseBeans();
            if (enterpriseBeans == null) {
                enterpriseBeans = new JBossEnterpriseBeansMetaData();
                ejbJarMetaData.setEnterpriseBeans(enterpriseBeans);
            }
            enterpriseBeans.add(beanMetaData);
        }
        return beanMetaData;
    }

    @Override
    public void setCtxProperties(Hashtable ctxProperties) {
        this.ctxProperties = ctxProperties;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    @Override
    public boolean isEjb() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isStateless(this.visible)) {
            return true;
        }
        if (EJB3Util.isMessageDriven(this.visible)) {
            return true;
        }
        return EJB3Util.isStatefulSession(this.visible);
    }

    @Override
    public boolean isJBossBeanType() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isService(this.visible)) {
            return true;
        }
        return EJB3Util.isConsumer(this.visible);
    }

    public List getContainers(ClassFile cf, Ejb3Deployment deployment) throws Exception {
        ArrayList<EJBContainer> containers = new ArrayList<EJBContainer>();
        this.populateBaseInfo();
        for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ++ejbIndex) {
            EJBContainer container;
            String ejbName = this.ejbNames.get(ejbIndex);
            if (this.ejbType == EJB_TYPE.STATELESS) {
                container = this.getStatelessContainer(ejbIndex, this.getEnterpriseBeanMetaData(deployment, ejbName, JBossSessionBeanMetaData.class));
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.STATEFUL) {
                container = this.getStatefulContainer(ejbIndex, this.getEnterpriseBeanMetaData(deployment, ejbName, JBossSessionBeanMetaData.class));
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.MESSAGE_DRIVEN) {
                container = this.getMDB(ejbIndex, this.getEnterpriseBeanMetaData(deployment, ejbName, JBossMessageDrivenBeanMetaData.class));
                this.validateMDBTransactionAttribute((MDB)container);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.SERVICE) {
                container = this.getServiceContainer(ejbIndex, this.getEnterpriseBeanMetaData(deployment, ejbName, JBossServiceBeanMetaData.class));
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.CONSUMER) {
                container = this.getConsumerContainer(ejbIndex, this.getEnterpriseBeanMetaData(deployment, ejbName, JBossConsumerBeanMetaData.class));
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            }
            log.debug((Object)("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + (Object)((Object)this.ejbType)));
        }
        return containers;
    }

    protected void validateMDBTransactionAttribute(MDB mdb) {
        TransactionAttributeType type;
        TransactionAttribute tx = (TransactionAttribute)mdb.resolveAnnotation(TransactionAttribute.class);
        if (tx != null && (type = tx.value()) != TransactionAttributeType.REQUIRED && type != TransactionAttributeType.NOT_SUPPORTED) {
            throw new RuntimeException("MDB " + mdb.getEjbName() + " has an invalid TransactionAttribute: " + type + ". Only REQUIRED and NOT_SUPPORTED are valid");
        }
    }

    protected String getAspectDomain(int ejbIndex, String defaultDomain) {
        return EJB3Util.getAspectDomain(this.visible, defaultDomain);
    }

    protected ServiceContainer getServiceContainer(int ejbIndex, JBossServiceBeanMetaData beanMetaData) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultServiceDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new ServiceContainer(this.deployment.getMbeanServer(), this.di.getClassLoader(), this.className, this.ejbNames.get(ejbIndex), (Domain)domain.getManager(), this.ctxProperties, this.deployment, beanMetaData);
    }

    protected ConsumerContainer getConsumerContainer(int ejbIndex, JBossConsumerBeanMetaData beanMetaData) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultConsumerDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new ConsumerContainer(this.ejbNames.get(ejbIndex), (Domain)domain.getManager(), this.di.getClassLoader(), this.className, this.ctxProperties, this.deployment, beanMetaData);
    }

    protected StatefulContainer getStatefulContainer(int ejbIndex, JBossSessionBeanMetaData beanMetaData) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultSFSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new StatefulContainer(this.di.getClassLoader(), this.className, this.ejbNames.get(ejbIndex), (Domain)domain.getManager(), this.ctxProperties, this.deployment, beanMetaData);
    }

    protected EJBContainer getStatelessContainer(int ejbIndex, JBossSessionBeanMetaData beanMetaData) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultSLSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new StatelessContainer(this.di.getClassLoader(), this.className, this.ejbNames.get(ejbIndex), (Domain)domain.getManager(), this.ctxProperties, this.deployment, beanMetaData);
    }

    protected String getMDBDomainName(int ejbIndex) {
        return this.defaultMDBDomain;
    }

    protected void createProxyFactories() {
    }

    protected MDB getMDB(int ejbIndex, JBossMessageDrivenBeanMetaData beanMetaData) throws Exception {
        String domainName = this.getMDBDomainName(ejbIndex);
        String containerName = this.getAspectDomain(ejbIndex, domainName);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        MDB container = new MDB(this.ejbNames.get(ejbIndex), (Domain)domain.getManager(), this.di.getClassLoader(), this.className, this.ctxProperties, this.deployment, beanMetaData);
        return container;
    }

    protected void populateBaseInfo() throws Exception {
        String ejbName = null;
        this.ejbClass = this.di.getClassLoader().loadClass(this.className);
        this.visible = (AnnotationsAttribute)this.cf.getAttribute("RuntimeVisibleAnnotations");
        if (this.visible != null) {
            this.annotation = this.visible.getAnnotation(Stateless.class.getName());
            if (this.annotation != null) {
                this.ejbType = EJB_TYPE.STATELESS;
            } else {
                this.annotation = this.visible.getAnnotation(Stateful.class.getName());
                if (this.annotation != null) {
                    this.ejbType = EJB_TYPE.STATEFUL;
                } else {
                    this.annotation = this.visible.getAnnotation(Entity.class.getName());
                    if (this.annotation != null) {
                        this.ejbType = EJB_TYPE.ENTITY;
                    } else {
                        this.annotation = this.visible.getAnnotation(MessageDriven.class.getName());
                        if (this.annotation != null) {
                            this.ejbType = EJB_TYPE.MESSAGE_DRIVEN;
                        } else {
                            this.annotation = this.visible.getAnnotation(Service.class.getName());
                            if (this.annotation != null) {
                                this.ejbType = EJB_TYPE.SERVICE;
                            } else {
                                this.annotation = this.visible.getAnnotation(Consumer.class.getName());
                                if (this.annotation != null) {
                                    this.ejbType = EJB_TYPE.CONSUMER;
                                }
                            }
                        }
                    }
                }
            }
            if (this.annotation != null) {
                StringMemberValue mv = (StringMemberValue)this.annotation.getMemberValue("name");
                ejbName = mv != null ? mv.getValue() : this.ejbClass.getSimpleName();
            }
        }
        if (ejbName != null) {
            this.ejbNames.add(ejbName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EJB_TYPE {
        STATELESS,
        STATEFUL,
        MESSAGE_DRIVEN,
        ENTITY,
        SERVICE,
        CONSUMER;

    }
}

