/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPassivationCache
implements StatefulCache {
    private StatefulContainer container;
    private HashMap<Object, StatefulBeanContext> cacheMap;
    private int createCount = 0;
    private int removeCount = 0;
    private boolean running;

    @Override
    public void initialize(EJBContainer container) throws Exception {
        this.container = (StatefulContainer)container;
        this.cacheMap = new HashMap();
    }

    public void start() {
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.clear();
        }
        this.running = false;
    }

    public StatefulBeanContext create() {
        return this.create((Class[])null, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues) {
        Object ctx = null;
        try {
            ctx = this.container.create((Class[])initTypes, initValues);
            ++this.createCount;
            HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(((StatefulBeanContext)ctx).getId(), (StatefulBeanContext)ctx);
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    @Override
    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            entry = this.cacheMap.get(key);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        if (markInUse) {
            if (entry.isRemoved()) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
            }
            entry.setInUse(true);
            entry.lastUsed = System.currentTimeMillis();
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        StatefulBeanContext ctx = null;
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            ctx = this.cacheMap.remove(key);
        }
        if (ctx == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        this.container.destroy(ctx);
        ++this.removeCount;
    }

    @Override
    public int getCacheSize() {
        return this.cacheMap.size();
    }

    @Override
    public int getTotalSize() {
        return this.cacheMap.size();
    }

    @Override
    public int getCreateCount() {
        return this.createCount;
    }

    @Override
    public int getPassivatedCount() {
        return 0;
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public int getAvailableCount() {
        int maxSize = this.getMaxSize();
        if (maxSize < 0) {
            return maxSize;
        }
        int currentSize = this.getCurrentSize();
        int available = maxSize - currentSize;
        return available;
    }

    @Override
    public int getMaxSize() {
        return -1;
    }

    @Override
    public int getCurrentSize() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }
}

