/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.Handle;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.Management;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.Service;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;
import org.jboss.ejb3.service.ServiceBeanContext;
import org.jboss.ejb3.service.ServiceDelegateWrapper;
import org.jboss.ejb3.service.ServiceMBeanDelegate;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContainer
extends SessionContainer
implements TimedObjectInvoker,
InvokableContext {
    ServiceMBeanDelegate delegate;
    Object singleton;
    BeanContext beanContext;
    MBeanServer mbeanServer;
    ObjectName delegateObjectName;
    private TimerService timerService;
    private Object mbean = new ServiceDelegateWrapper(this);
    private Method timeoutMethod;
    private TimerServiceFactory timerServiceFactory;
    private static final Logger log = Logger.getLogger(ServiceContainer.class);
    private static final String METHOD_NAME_LIFECYCLE_CALLBACK_CREATE = "create";
    private static final String METHOD_NAME_LIFECYCLE_CALLBACK_START = "start";
    private static final String METHOD_NAME_LIFECYCLE_CALLBACK_STOP = "stop";
    private static final String METHOD_NAME_LIFECYCLE_CALLBACK_DESTROY = "destroy";

    public ServiceContainer(MBeanServer server, ClassLoader cl, String beanClassName, String ejbName, Domain domain, Hashtable ctxProperties, Ejb3Deployment deployment, JBossServiceBeanMetaData beanMetaData) throws ClassNotFoundException {
        super(cl, beanClassName, ejbName, domain, ctxProperties, deployment, (JBossSessionBeanMetaData)beanMetaData);
        this.mbeanServer = server;
        this.initializeTimeoutMethod();
    }

    public void callTimeout(Timer timer) throws Exception {
        if (this.timeoutMethod == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        AllowedOperationsAssociation.pushInMethodFlag((int)AllowedOperationsFlags.IN_EJB_TIMEOUT);
        try {
            this.localInvoke(this.timeoutMethod, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    @Override
    public BeanContext<?> createBeanContext() {
        return new ServiceBeanContext(this, this.singleton);
    }

    private void initializeTimeoutMethod() {
        JBossSessionBeanMetaData metaData = this.getMetaData();
        NamedMethodMetaData timeoutMethodMetaData = null;
        if (metaData != null) {
            timeoutMethodMetaData = metaData.getTimeoutMethod();
        }
        this.timeoutMethod = this.getTimeoutCallback(timeoutMethodMetaData, this.getBeanClass());
    }

    @Override
    public Serializable createSession(Class<?>[] initTypes, Object[] initArgs) {
        throw new UnsupportedOperationException("Service Containers have no Sessions");
    }

    @Override
    protected String getJndiRegistrarBindName() {
        return this.isClustered() ? "org.jboss.ejb3.JndiRegistrar.Session.ClusteredServiceJndiRegistrar" : "org.jboss.ejb3.JndiRegistrar.Session.ServiceJndiRegistrar";
    }

    @Override
    public Object getMBean() {
        return this.mbean;
    }

    public Object getSingleton() {
        return this.singleton;
    }

    @Override
    public void create() throws Exception {
        super.create();
        this.singleton = super.construct();
        this.registerManagementInterface();
        this.invokeOptionalMethod(METHOD_NAME_LIFECYCLE_CALLBACK_CREATE);
    }

    @Override
    public void instantiated() {
        super.instantiated();
    }

    @Override
    protected List<Class<?>> resolveBusinessInterfaces() {
        Class<?>[] implIfaces;
        Class iface;
        List<Class<?>> interfaces = super.resolveBusinessInterfaces();
        Management man = (Management)this.resolveAnnotation(Management.class);
        if (man != null && (iface = man.value()) != null) {
            interfaces.add(iface);
        }
        for (Class<?> iface2 : implIfaces = this.getBeanClass().getInterfaces()) {
            if (iface2.getAnnotation(Management.class) == null) continue;
            interfaces.add(iface2);
        }
        return interfaces;
    }

    @Override
    protected void reinitialize() {
        super.reinitialize();
        this.singleton = super.construct();
        this.invokeOptionalMethod(METHOD_NAME_LIFECYCLE_CALLBACK_CREATE);
    }

    @Override
    protected void lockedStart() throws Exception {
        super.lockedStart();
        try {
            this.initBeanContext();
            this.timerService = this.timerServiceFactory.createTimerService((TimedObjectInvoker)this);
            this.injectDependencies(this.beanContext);
            this.invokePostConstruct(this.beanContext);
            this.timerServiceFactory.restoreTimerService(this.timerService);
        }
        catch (Exception e) {
            log.error((Object)("Encountered an error in start of " + this.getMetaData().getEjbName()), (Throwable)e);
            try {
                this.lockedStop();
            }
            catch (Exception stopEx) {
                log.error((Object)"Error during forced container stop", (Throwable)stopEx);
            }
            throw e;
        }
    }

    @Override
    protected void lockedStop() throws Exception {
        this.invokePreDestroy(this.beanContext);
        if (this.timerService != null) {
            this.timerServiceFactory.suspendTimerService(this.timerService);
            this.timerService = null;
        }
        super.lockedStop();
    }

    @Override
    public void destroy() throws Exception {
        this.invokeOptionalMethod(METHOD_NAME_LIFECYCLE_CALLBACK_DESTROY);
        this.unregisterManagementInterface();
        this.singleton = null;
        this.beanContext = null;
        super.destroy();
    }

    @Override
    public void initializePool() throws Exception {
        this.resolveInjectors();
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public TimerService getTimerService(Object pKey) {
        assert (this.timerService != null) : "Timer Service not yet initialized";
        return this.timerService;
    }

    private void setTcl(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private Object invokeOptionalBusinessMethod(String methodName) throws Exception {
        try {
            Method method = this.getBeanClass().getMethod(methodName, new Class[0]);
            try {
                return this.localInvoke(method, null);
            }
            catch (Throwable t) {
                throw this.sanitize(t);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOptionalMethod(String methodName) {
        ClassLoader oldCl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            this.setTcl(this.getClassloader());
            Class[] parameterTypes = new Class[]{};
            Method method = this.singleton.getClass().getMethod(methodName, parameterTypes);
            Object[] args = new Object[]{};
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempting to invoke \"" + methodName + "()\" upon " + this.getBeanClassName() + "..."));
            }
            method.invoke(this.singleton, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Could not execute optional method \"" + methodName + "\" upon " + this.getBeanClassName() + ", so ignoring"));
            }
        }
        finally {
            this.setTcl(oldCl);
        }
    }

    @Override
    public Object localInvoke(Object id, Method method, Object[] args) throws Throwable {
        return this.localInvoke(method, args);
    }

    @Override
    public Object localHomeInvoke(Method method, Object[] args) throws Throwable {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.invokeStats.callIn();
            Thread.currentThread().setContextClassLoader(this.classloader);
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = this.getAdvisor().getMethodInfo(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            StatefulContainerInvocation nextInvocation = new StatefulContainerInvocation(info, null);
            nextInvocation.setAdvisor(this.getAdvisor());
            nextInvocation.setArguments(args);
            nextInvocation = this.populateInvocation(nextInvocation);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            if (method != null) {
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                this.invokeStats.updateStats(method, elapsed);
            }
            this.invokeStats.callOut();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocationResponse dynamicInvoke(Invocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        StatefulContainerInvocation newSi = null;
        MethodInvocation si = (MethodInvocation)invocation;
        MethodInfo info = this.getAdvisor().getMethodInfo(si.getMethodHash());
        Method method = info.getUnadvisedMethod();
        try {
            InvocationResponse response;
            this.invokeStats.callIn();
            Thread.currentThread().setContextClassLoader(this.classloader);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            newSi = new StatefulContainerInvocation(info, null);
            newSi.setArguments(si.getArguments());
            newSi.setMetaData(si.getMetaData());
            newSi.setAdvisor(this.getAdvisor());
            newSi = this.populateInvocation(newSi);
            Object rtn = null;
            try {
                rtn = newSi.invokeNext();
            }
            catch (Throwable throwable) {
                InvocationResponse invocationResponse = ServiceContainer.marshallException(invocation, throwable, newSi.getResponseContextInfo());
                if (method != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    this.invokeStats.updateStats(method, elapsed);
                }
                this.invokeStats.callOut();
                Thread.currentThread().setContextClassLoader(oldLoader);
                return invocationResponse;
            }
            InvocationResponse invocationResponse = response = SessionContainer.marshallResponse(invocation, rtn, newSi.getResponseContextInfo());
            return invocationResponse;
        }
        finally {
            if (method != null) {
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                this.invokeStats.updateStats(method, elapsed);
            }
            this.invokeStats.callOut();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBeanContext() throws RuntimeException {
        if (this.beanContext == null) {
            Object object = this.singleton;
            synchronized (object) {
                if (this.beanContext == null) {
                    this.beanContext = this.createBeanContext();
                    this.pushEnc();
                    try {
                        this.beanContext.initialiseInterceptorInstances();
                    }
                    finally {
                        this.popEnc();
                    }
                }
            }
        }
    }

    @Override
    public BeanContext<?> peekContext() {
        return this.beanContext;
    }

    @Override
    protected StatefulContainerInvocation populateInvocation(StatefulContainerInvocation invocation) {
        invocation.setBeanContext(this.beanContext);
        return invocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void injectDependencies(BeanContext ctx) {
        if (this.injectors != null) {
            try {
                this.pushEnc();
                for (Injector injector : this.injectors) {
                    injector.inject(ctx);
                }
            }
            finally {
                this.popEnc();
            }
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate.getAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate.setAttribute(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return this.delegate.setAttributes(attributes);
    }

    @Deprecated
    public Object invoke(Object proxy, SerializableMethod method, Object[] args) throws Throwable {
        return this.localInvoke(method.toMethod(), args);
    }

    public Object invoke(Serializable session, Class<?> invokedBusinessInterface, Method method, Object[] args) throws Throwable {
        return this.localInvoke(method, args);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        assert (this.delegate != null) : "MBean delegate was null, cannot perform invocation";
        return this.delegate.invoke(actionName, params, signature);
    }

    public MBeanInfo getMBeanInfo() {
        return this.delegate.getMBeanInfo();
    }

    public Object createLocalProxy(Object id, LocalBinding binding) throws Exception {
        throw new NotImplementedException(this + " is using unsupported legacy Proxy implementation");
    }

    @Deprecated
    public Object createRemoteProxy(Object id, RemoteBinding binding) throws Exception {
        throw new NotImplementedException(this + " is no longer using unsupported (legacy) proxy impl from ejb3-core");
    }

    public String getTimedObjectId() {
        return this.getDeploymentQualifiedName();
    }

    private void registerManagementInterface() {
        try {
            Service service;
            String objname;
            Management annotation = this.getAnnotation(Management.class);
            Class<?> intf = null;
            if (annotation != null) {
                intf = annotation.value();
            }
            if (intf == null) {
                Class<?>[] interfaces = this.getBeanClass().getInterfaces();
                int interfaceIndex = 0;
                while (intf == null && interfaceIndex < interfaces.length) {
                    if (interfaces[interfaceIndex].getAnnotation(Management.class) != null) {
                        intf = interfaces[interfaceIndex];
                        continue;
                    }
                    ++interfaceIndex;
                }
            }
            DependencyPolicy containerPolicy = this.getDependencyPolicy();
            DependencyPolicy newPolicy = containerPolicy.clone();
            String cName = this.getObjectName().getCanonicalName();
            newPolicy.addDependency(cName);
            if (this.mbeanServer == null) {
                try {
                    this.mbeanServer = MBeanServerLocator.locateJBoss();
                }
                catch (IllegalStateException ise) {
                    log.warn((Object)ise);
                }
            }
            ObjectName objectName = this.delegateObjectName = (objname = (service = this.getAnnotation(Service.class)).objectName()) == null || objname.equals("") ? new ObjectName(this.getObjectName().getCanonicalName() + ",type=ManagementInterface") : new ObjectName(objname);
            if (intf != null) {
                if (this.mbeanServer == null) {
                    throw new RuntimeException("There is a @Management interface on " + this.ejbName + " but the MBeanServer has not been initialized for it");
                }
                this.delegate = new ServiceMBeanDelegate(this.mbeanServer, this, intf, this.delegateObjectName);
                this.mbeanServer.registerMBean(this.delegate, this.delegateObjectName);
                this.getDeployment().getKernelAbstraction().install(this.delegateObjectName.getCanonicalName(), newPolicy, null, this.delegate);
            } else if (service.xmbean().length() > 0) {
                if (this.mbeanServer == null) {
                    throw new RuntimeException(this.ejbName + "is defined as an XMBean, but the MBeanServer has not been initialized for it");
                }
                this.delegate = new ServiceMBeanDelegate(this.mbeanServer, this, service.xmbean(), this.delegateObjectName);
                this.getDeployment().getKernelAbstraction().installMBean(this.delegateObjectName, newPolicy, this.delegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem registering @Management interface for @Service " + this.getBeanClass(), e);
        }
    }

    private void unregisterManagementInterface() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.delegate != null) {
            this.mbeanServer.unregisterMBean(this.delegateObjectName);
        }
    }

    @Override
    protected void removeHandle(Handle handle) {
        throw new RuntimeException("Don't do this");
    }

    private Exception sanitize(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        return (Exception)t;
    }

    @Inject
    public void setTimerServiceFactory(TimerServiceFactory factory) {
        this.timerServiceFactory = factory;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.invokeOptionalBusinessMethod(METHOD_NAME_LIFECYCLE_CALLBACK_START);
    }

    @Override
    public void stop() throws Exception {
        this.invokeOptionalBusinessMethod(METHOD_NAME_LIFECYCLE_CALLBACK_STOP);
        super.stop();
    }
}

