/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Serializable;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;

public class StatefulBeanContextReference
implements Serializable {
    private static final long serialVersionUID = -7622266426902284032L;
    private transient StatefulBeanContext beanContext;
    private Object oid;
    private String containerGuid;
    private String containerClusterUid;
    private boolean isClustered = false;

    public StatefulBeanContextReference(StatefulBeanContext beanContext) {
        assert (beanContext != null) : "beanContext is null";
        this.beanContext = beanContext;
        this.oid = beanContext.getId();
        this.containerGuid = Ejb3Registry.guid(beanContext.getContainer());
        this.containerClusterUid = Ejb3Registry.clusterUid(beanContext.getContainer());
        this.isClustered = beanContext.getContainer().isClustered();
    }

    public StatefulBeanContext getBeanContext() {
        if (this.beanContext == null) {
            StatefulContainer container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.isClustered && container == null) {
                container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
            this.beanContext = container.getCache().get(this.oid, false);
            assert (this.beanContext != null) : "beanContext no longer in cache";
        }
        return this.beanContext;
    }
}

