/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectAnnotationLoaderStrategy;
import org.jboss.aop.AspectAnnotationLoaderStrategySupport;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.microcontainer.beans.metadata.AbstractDeclareBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.AdviceData;
import org.jboss.aop.microcontainer.beans.metadata.AdviceOrInterceptorData;
import org.jboss.aop.microcontainer.beans.metadata.AfterAdviceData;
import org.jboss.aop.microcontainer.beans.metadata.AnnotationIntroductionBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.AspectBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.AspectManagerAwareBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.BaseInterceptorData;
import org.jboss.aop.microcontainer.beans.metadata.BeforeAdviceData;
import org.jboss.aop.microcontainer.beans.metadata.BindBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.CFlowEntry;
import org.jboss.aop.microcontainer.beans.metadata.CFlowStackBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.DeclareErrorBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.DeclareWarningBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.DynamicCflowBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.FinallyAdviceData;
import org.jboss.aop.microcontainer.beans.metadata.InterceptorBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.InterceptorRefData;
import org.jboss.aop.microcontainer.beans.metadata.IntroductionBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.MixinData;
import org.jboss.aop.microcontainer.beans.metadata.NamedPointcutBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.PrecedenceBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.ThrowingAdviceData;
import org.jboss.aop.microcontainer.beans.metadata.TypeDefBeanMetaDataFactory;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrocontainerAnnotationLoaderStrategy
extends AspectAnnotationLoaderStrategySupport {
    List<AspectManagerAwareBeanMetaDataFactory> factories = new ArrayList<AspectManagerAwareBeanMetaDataFactory>();

    public List<AspectManagerAwareBeanMetaDataFactory> getFactories() {
        return this.factories;
    }

    public void deployAspect(AspectAnnotationLoader loader, boolean isFactory, String name, Scope scope) {
        AspectBeanMetaDataFactory aspect = new AspectBeanMetaDataFactory();
        this.deployAspectOrInterceptor(aspect, isFactory, name, scope);
    }

    public void undeployAspect(AspectAnnotationLoader loader, String name) {
    }

    public void deployInterceptor(AspectAnnotationLoader loader, boolean isFactory, String name, Scope scope) {
        InterceptorBeanMetaDataFactory aspect = new InterceptorBeanMetaDataFactory();
        this.deployAspectOrInterceptor(aspect, isFactory, name, scope);
    }

    public void undeployInterceptor(AspectAnnotationLoader loader, String name) {
    }

    public void deployAspectMethodBinding(AspectAnnotationLoader loader, AdviceType internalAdviceType, String aspectDefName, String methodName, String bindingName, String pointcutString, String cflow, ASTCFlowExpression cflowExpression) throws Exception {
        AdviceData entry = null;
        if (internalAdviceType == AdviceType.AROUND) {
            entry = new AdviceData();
        } else if (internalAdviceType == AdviceType.BEFORE) {
            entry = new BeforeAdviceData();
        } else if (internalAdviceType == AdviceType.AFTER) {
            entry = new AfterAdviceData();
        } else if (internalAdviceType == AdviceType.THROWING) {
            entry = new ThrowingAdviceData();
        } else if (internalAdviceType == AdviceType.FINALLY) {
            entry = new FinallyAdviceData();
        }
        entry.setAdviceMethod(methodName);
        entry.setRefName(aspectDefName);
        this.deployBinding(bindingName, pointcutString, cflow, entry);
    }

    public void undeployAspectMethodBinding(AspectAnnotationLoader loader, String bindingName, String className, String methodName) {
    }

    public void deployInterceptorBinding(AspectAnnotationLoader loader, String name, String pointcutString, String cflow, ASTCFlowExpression cflowExpression) throws Exception {
        InterceptorRefData entry = new InterceptorRefData();
        entry.setRefName(name);
        this.deployBinding(name, pointcutString, cflow, entry);
    }

    public void undeployInterceptorBinding(AspectAnnotationLoader loader, String name) {
    }

    private void deployAspectOrInterceptor(AspectBeanMetaDataFactory aspect, boolean isFactory, String name, Scope scope) {
        aspect.setScope(scope.name());
        aspect.setName(name);
        if (isFactory) {
            aspect.setFactory(name);
        } else {
            aspect.setBean(name);
        }
        this.factories.add(aspect);
    }

    private void deployBinding(String name, String pointcutString, String cflow, BaseInterceptorData entry) {
        BindBeanMetaDataFactory bind = new BindBeanMetaDataFactory();
        bind.setName("Binding$" + name);
        bind.setPointcut(pointcutString);
        bind.setCflow(cflow);
        bind.setInterceptors(Collections.singletonList(entry));
        this.factories.add(bind);
    }

    public void deployCFlow(AspectAnnotationLoader loader, AspectAnnotationLoaderStrategy.CFlowStackInfo stack) {
        CFlowStackBeanMetaDataFactory cflow = new CFlowStackBeanMetaDataFactory();
        cflow.setName(stack.getName());
        AspectAnnotationLoaderStrategy.CFlowInfo[] cflows = stack.getCFlows();
        if (cflows != null) {
            ArrayList<CFlowEntry> entries = new ArrayList<CFlowEntry>();
            for (AspectAnnotationLoaderStrategy.CFlowInfo current : cflows) {
                CFlowEntry entry = new CFlowEntry();
                entry.setExpr(current.getExpr());
                entry.setCalled(!current.isNot());
                entries.add(entry);
            }
            cflow.setCalledEntries(entries);
        }
        this.factories.add(cflow);
    }

    public void undeployCFlow(AspectAnnotationLoader loader, String name) {
    }

    public void deployAnnotationIntroduction(AspectAnnotationLoader loader, String expr, String annotation, boolean invisible) {
        AnnotationIntroductionBeanMetaDataFactory intro = new AnnotationIntroductionBeanMetaDataFactory();
        intro.setExpr(expr);
        intro.setAnnotation(annotation);
        intro.setInvisible(invisible);
        this.factories.add(intro);
    }

    public void undeployAnnotationIntroduction(AspectAnnotationLoader loader, String expr, String annotation, boolean invisible) {
    }

    public void deployTypedef(AspectAnnotationLoader loader, String name, String expr) throws Exception {
        TypeDefBeanMetaDataFactory typedef = new TypeDefBeanMetaDataFactory();
        typedef.setName(name);
        typedef.setExpr(expr);
        this.factories.add(typedef);
    }

    public void undeployTypedef(AspectAnnotationLoader loader, String name) {
    }

    public void deployDynamicCFlow(AspectAnnotationLoader loader, String name, String clazz) {
        DynamicCflowBeanMetaDataFactory dcflow = new DynamicCflowBeanMetaDataFactory();
        dcflow.setName(name);
        dcflow.setBean(clazz);
        this.factories.add(dcflow);
    }

    public void undeployDynamicCFlow(AspectAnnotationLoader loader, String name) {
    }

    public void deployInterfaceIntroduction(AspectAnnotationLoader loader, AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo introduction) {
        IntroductionBeanMetaDataFactory intro = new IntroductionBeanMetaDataFactory();
        intro.setName(introduction.getName());
        intro.setExpr(introduction.getExpr());
        intro.setBean(introduction.getTarget());
        if (introduction.getInterfaces() != null) {
            intro.setInterfaces(this.createCommaSeparatedInterfaceString(introduction.getInterfaces()));
        }
        if (introduction.getMixins() != null) {
            ArrayList<MixinData> mixinDatas = new ArrayList<MixinData>();
            for (AspectAnnotationLoaderStrategy.InterfaceIntroductionMixinInfo mixin : introduction.getMixins()) {
                MixinData mixinData = new MixinData();
                mixinData.setMixin(mixin.getClassname());
                mixinData.setInterfaces(this.createCommaSeparatedInterfaceString(mixin.getInterfaces()));
                mixinData.setConstruction(mixin.getConstruction());
                mixinDatas.add(mixinData);
            }
            intro.setMixins(mixinDatas);
        }
        this.factories.add(intro);
    }

    public void undeployInterfaceIntroduction(AspectAnnotationLoader loader, String name) {
    }

    public void deployPointcut(AspectAnnotationLoader loader, String name, String expr) throws Exception {
        NamedPointcutBeanMetaDataFactory pointcut = new NamedPointcutBeanMetaDataFactory();
        pointcut.setName(name);
        pointcut.setExpr(expr);
        this.factories.add(pointcut);
    }

    public void undeployPointcut(AspectAnnotationLoader loader, String name) {
    }

    public void deployPrecedence(AspectAnnotationLoader loader, String name, PrecedenceDefEntry[] pentries) {
        PrecedenceBeanMetaDataFactory precedence = new PrecedenceBeanMetaDataFactory();
        ArrayList<BaseInterceptorData> entries = new ArrayList<BaseInterceptorData>();
        for (PrecedenceDefEntry pentry : pentries) {
            String clazz = pentry.getInterceptorClass();
            String advice = pentry.getAdviceMethod();
            AdviceOrInterceptorData entry = null;
            if (advice == null) {
                entry = new InterceptorRefData();
                ((BaseInterceptorData)entry).setRefName(clazz);
            } else {
                entry = new AdviceData();
                ((BaseInterceptorData)entry).setRefName(clazz);
                ((AdviceData)entry).setAdviceMethod(advice);
            }
            entries.add(entry);
            precedence.setEntries(entries);
        }
        this.factories.add(precedence);
    }

    public void undeployPrecedence(AspectAnnotationLoader loader, String name) {
        super.undeployPrecedence(loader, name);
    }

    public void deployDeclare(AspectAnnotationLoader loader, String name, String expr, boolean warning, String msg) throws Exception {
        AbstractDeclareBeanMetaDataFactory declare = warning ? new DeclareWarningBeanMetaDataFactory() : new DeclareErrorBeanMetaDataFactory();
        declare.setName(name);
        declare.setExpr(expr);
        declare.setMessage(msg);
        this.factories.add(declare);
    }

    private String createCommaSeparatedInterfaceString(String[] interfaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < interfaces.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(interfaces[i]);
        }
        return sb.toString();
    }
}

