/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.ws.addressing.WsaTubeHelper;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.api.DistributedPropertySet;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Packet
extends DistributedPropertySet {
    private Message message;
    public boolean wasTransportSecure;
    public static final String INBOUND_TRANSPORT_HEADERS = "com.sun.xml.ws.api.message.packet.inbound.transport.headers";
    public static final String OUTBOUND_TRANSPORT_HEADERS = "com.sun.xml.ws.api.message.packet.outbound.transport.headers";
    @PropertySet.Property(value={"com.sun.xml.ws.handler.config"})
    public HandlerConfiguration handlerConfig;
    @PropertySet.Property(value={"com.sun.xml.ws.client.handle"})
    public BindingProvider proxy;
    public EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation;
    public String acceptableMimeTypes;
    public WebServiceContextDelegate webServiceContextDelegate;
    @Nullable
    public TransportBackChannel transportBackChannel;
    @PropertySet.Property(value={"com.sun.xml.ws.api.server.WSEndpoint"})
    public WSEndpoint endpoint;
    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String soapAction;
    @PropertySet.Property(value={"com.sun.xml.ws.server.OneWayOperation"})
    public Boolean expectReply;
    @Deprecated
    public Boolean isOneWay;
    private Set<String> handlerScopePropertyNames;
    public final Map<String, Object> invocationProperties;
    private static final PropertySet.PropertyMap model = Packet.parse(Packet.class);

    public Packet(Message request) {
        this();
        this.message = request;
    }

    public Packet() {
        this.invocationProperties = new HashMap<String, Object>();
    }

    private Packet(Packet that) {
        that.copySatelliteInto(this);
        this.handlerConfig = that.handlerConfig;
        this.invocationProperties = that.invocationProperties;
        this.handlerScopePropertyNames = that.handlerScopePropertyNames;
        this.contentNegotiation = that.contentNegotiation;
        this.wasTransportSecure = that.wasTransportSecure;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        if (this.endpointAddress == null) {
            return null;
        }
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String s) {
        this.endpointAddress = s == null ? null : EndpointAddress.create(s);
    }

    @PropertySet.Property(value={"com.sun.xml.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation != null ? this.contentNegotiation.toString() : null;
    }

    public void setContentNegotiationString(String s) {
        if (s == null) {
            this.contentNegotiation = null;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.reference.parameters"})
    @NotNull
    public List<Element> getReferenceParameters() {
        ArrayList<Element> refParams = new ArrayList<Element>();
        HeaderList hl = this.message.getHeaders();
        for (Header h : hl) {
            String attr = h.getAttribute(AddressingVersion.W3C.nsUri, "IsReferenceParameter");
            if (attr == null || !attr.equals("true") && !attr.equals("1")) continue;
            Document d = DOMUtil.createDom();
            SAX2DOMEx s2d = new SAX2DOMEx((Node)d);
            try {
                h.writeTo((ContentHandler)s2d, XmlUtil.DRACONIAN_ERROR_HANDLER);
                refParams.add((Element)d.getLastChild());
            }
            catch (SAXException e) {
                throw new WebServiceException(e);
            }
        }
        return refParams;
    }

    @PropertySet.Property(value={"com.sun.xml.ws.api.message.HeaderList"})
    HeaderList getHeaderList() {
        if (this.message == null) {
            return null;
        }
        return this.message.getHeaders();
    }

    public final Set<String> getHandlerScopePropertyNames(boolean readOnly) {
        Set<String> o = this.handlerScopePropertyNames;
        if (o == null) {
            if (readOnly) {
                return Collections.emptySet();
            }
            this.handlerScopePropertyNames = o = new HashSet<String>();
        }
        return o;
    }

    public final Set<String> getApplicationScopePropertyNames(boolean readOnly) {
        assert (false);
        return new HashSet<String>();
    }

    @Deprecated
    public Packet createResponse(Message msg) {
        Packet response = new Packet(this);
        response.setMessage(msg);
        return response;
    }

    public Packet createClientResponse(Message msg) {
        Packet response = new Packet(this);
        response.setMessage(msg);
        return response;
    }

    public Packet createServerResponse(@Nullable Message responseMessage, @Nullable WSDLPort wsdlPort, @Nullable SEIModel seiModel, @NotNull WSBinding binding) {
        Packet r = this.createClientResponse(responseMessage);
        AddressingVersion av = binding.getAddressingVersion();
        if (av == null) {
            return r;
        }
        String inputAction = this.getMessage().getHeaders().getAction(av, binding.getSOAPVersion());
        if (inputAction == null) {
            return r;
        }
        if (responseMessage == null || wsdlPort != null && this.message.isOneWay(wsdlPort)) {
            return r;
        }
        this.populateAddressingHeaders(binding, r, wsdlPort, seiModel);
        return r;
    }

    public Packet createServerResponse(@Nullable Message responseMessage, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion soapVersion, @NotNull String action) {
        Packet responsePacket = this.createClientResponse(responseMessage);
        if (addressingVersion == null) {
            return responsePacket;
        }
        String inputAction = this.getMessage().getHeaders().getAction(addressingVersion, soapVersion);
        if (inputAction == null) {
            return responsePacket;
        }
        this.populateAddressingHeaders(responsePacket, addressingVersion, soapVersion, action);
        return responsePacket;
    }

    private void populateAddressingHeaders(Packet responsePacket, AddressingVersion av, SOAPVersion sv, String action) {
        WSEndpointReference refpEPR;
        WSEndpointReference replyTo;
        if (av == null) {
            return;
        }
        if (responsePacket.getMessage() == null) {
            return;
        }
        HeaderList hl = responsePacket.getMessage().getHeaders();
        try {
            replyTo = this.message.getHeaders().getReplyTo(av, sv);
            if (replyTo != null) {
                hl.add(new StringHeader(av.toTag, replyTo.getAddress()));
            }
        }
        catch (InvalidMapException e) {
            replyTo = null;
        }
        if (action != null) {
            hl.add(new StringHeader(av.actionTag, action));
        }
        hl.add(new StringHeader(av.messageIDTag, responsePacket.getMessage().getID(av, sv)));
        String mid = this.getMessage().getHeaders().getMessageID(av, sv);
        if (mid != null) {
            hl.add(new RelatesToHeader(av.relatesToTag, mid));
        }
        if (responsePacket.getMessage().isFault()) {
            refpEPR = this.message.getHeaders().getFaultTo(av, sv);
            if (refpEPR == null) {
                refpEPR = replyTo;
            }
        } else {
            refpEPR = replyTo;
        }
        if (refpEPR != null) {
            refpEPR.addReferenceParameters(hl);
        }
    }

    private void populateAddressingHeaders(WSBinding binding, Packet responsePacket, WSDLPort wsdlPort, SEIModel seiModel) {
        AddressingVersion addressingVersion = binding.getAddressingVersion();
        if (addressingVersion == null) {
            return;
        }
        WsaTubeHelper wsaHelper = addressingVersion.getWsaHelper(wsdlPort, seiModel, binding);
        String action = responsePacket.message.isFault() ? wsaHelper.getFaultAction(this, responsePacket) : wsaHelper.getOutputAction(this);
        this.populateAddressingHeaders(responsePacket, addressingVersion, binding.getSOAPVersion(), action);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

