/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.security.RolesAllowed;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.jboss.EjbNameThreadLocal;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesAllowedProcessor<T extends AnnotatedElement>
extends AbstractFinderUser
implements Processor<MethodPermissionsMetaData, T> {
    public RolesAllowedProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(MethodPermissionsMetaData metaData, T type) {
        MethodPermissionMetaData perm;
        MethodsMetaData methods;
        RolesAllowed allowed = this.finder.getAnnotation(type, RolesAllowed.class);
        if (allowed == null) {
            return;
        }
        Method method = null;
        if (type instanceof Method) {
            method = (Method)type;
        }
        String ejbName = EjbNameThreadLocal.ejbName.get();
        MethodMetaData mmd = ProcessorUtils.createMethod(ejbName, method);
        MethodPermissionsMetaData existingPerms = metaData.getMethodPermissionsByEjbName(ejbName);
        if (existingPerms != null && !existingPerms.isEmpty()) {
            for (MethodPermissionMetaData existingPerm : existingPerms) {
                for (MethodMetaData existingMethod : existingPerm.getMethods()) {
                    if (!existingMethod.getMethodName().equals(mmd.getMethodName()) || !existingMethod.getMethodParams().equals(mmd.getMethodParams())) continue;
                    return;
                }
            }
        }
        if ((methods = (perm = new MethodPermissionMetaData()).getMethods()) == null) {
            methods = new MethodsMetaData();
            perm.setMethods(methods);
        }
        HashSet<String> roles = new HashSet<String>();
        for (String role : allowed.value()) {
            roles.add(role);
        }
        perm.setRoles(roles);
        Descriptions descriptions = ProcessorUtils.getDescription("@RolesAllowed for: " + type);
        mmd.setDescriptions(descriptions);
        methods.add(mmd);
        metaData.add(perm);
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(RolesAllowed.class);
    }
}

