/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.cmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jboss.wsf.spi.tools.WSContractProvider;

public class WSProvide {
    private boolean generateSource = false;
    private boolean generateWsdl = false;
    private boolean quiet = false;
    private boolean showTraces = false;
    private boolean loadProvider = false;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private File outputDir = new File("output");
    private File resourceDir = null;
    private File sourceDir = null;
    public static final String PROGRAM_NAME = System.getProperty("program.name", WSProvide.class.getSimpleName());

    public static void main(String[] args) {
        WSProvide generate = new WSProvide();
        String endpoint = generate.parseArguments(args);
        System.exit(generate.generate(endpoint));
    }

    private String parseArguments(String[] args) {
        int endpointPos;
        int c;
        String shortOpts = "hwko:r:s:c:qtl";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("wsdl", 0, null, 119), new LongOpt("keep", 0, null, 107), new LongOpt("output", 1, null, 111), new LongOpt("resource", 1, null, 114), new LongOpt("source", 1, null, 115), new LongOpt("classpath", 1, null, 99), new LongOpt("quiet", 0, null, 113), new LongOpt("show-traces", 0, null, 116), new LongOpt("load-provider", 0, null, 108)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
        while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 114: {
                    this.resourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 119: {
                    this.generateWsdl = true;
                    break;
                }
                case 116: {
                    this.showTraces = true;
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 99: {
                    this.processClassPath(getopt.getOptarg());
                    break;
                }
                case 108: {
                    this.loadProvider = true;
                    break;
                }
                case 104: {
                    WSProvide.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        if (this.loadProvider) {
            WSContractProvider gen = WSContractProvider.newInstance(this.loader);
            System.out.println("WSContractProvider instance: " + gen.getClass().getCanonicalName());
            System.exit(0);
        }
        if ((endpointPos = getopt.getOptind()) >= args.length) {
            System.err.println("Error: endpoint implementation was not specified!");
            WSProvide.printHelp();
            System.exit(1);
        }
        return args[endpointPos];
    }

    private int generate(String endpoint) {
        try {
            this.loader.loadClass(endpoint);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: Could not load class [" + endpoint + "]. Did you specify a valid --classpath?");
            return 1;
        }
        WSContractProvider gen = WSContractProvider.newInstance(this.loader);
        gen.setGenerateWsdl(this.generateWsdl);
        gen.setGenerateSource(this.generateSource);
        gen.setOutputDirectory(this.outputDir);
        if (this.resourceDir != null) {
            gen.setResourceDirectory(this.resourceDir);
        }
        if (this.sourceDir != null) {
            gen.setSourceDirectory(this.sourceDir);
        }
        if (!this.quiet) {
            gen.setMessageStream(System.out);
        }
        try {
            gen.provide(endpoint);
            return 0;
        }
        catch (Throwable t) {
            System.err.println("Error: Could not generate. (use --show-traces to see full traces)");
            if (!this.showTraces) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getSimpleName();
                }
                System.err.println("Error: " + message);
            } else {
                t.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private void processClassPath(String classPath) {
        String[] entries = classPath.split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>(entries.length);
        for (String entry : entries) {
            try {
                urls.add(new File(entry).toURL());
            }
            catch (MalformedURLException e) {
                System.err.println("Error: a classpath entry was malformed: " + entry);
            }
        }
        this.loader = new URLClassLoader(urls.toArray(new URL[0]), this.loader);
    }

    private static void printHelp() {
        PrintStream out = System.out;
        out.println("WSProvideTask generates portable JAX-WS artifacts for an endpoint implementation.\n");
        out.println("usage: " + PROGRAM_NAME + " [options] <endpoint class name>\n");
        out.println("options: ");
        out.println("    -h, --help                  Show this help message");
        out.println("    -k, --keep                  Keep/Generate Java source");
        out.println("    -w, --wsdl                  Enable WSDL file generation");
        out.println("    -c, --classpath=<path>      The classpath that contains the endpoint");
        out.println("    -o, --output=<directory>    The directory to put generated artifacts");
        out.println("    -r, --resource=<directory>  The directory to put resource artifacts");
        out.println("    -s, --source=<directory>    The directory to put Java source");
        out.println("    -q, --quiet                 Be somewhat more quiet");
        out.println("    -t, --show-traces           Show full exception stack traces");
        out.println("    -l, --load-provider         Load the provider and exit (debug utility)");
        out.flush();
    }
}

