/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private URI id;
    private URI type;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private Set<AttributeValue> attributeValues = null;

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this.id = id;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        if (this.attributeValues == null) {
            this.attributeValues = new HashSet<AttributeValue>();
        }
        this.attributeValues.add(value);
        if (value != null) {
            this.type = value.getType();
        }
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, Set<AttributeValue> values) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.attributeValues = values;
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this(id, issuer, issueInstant, value);
        this.type = type;
    }

    public static Attribute getInstance(Node root) throws ParsingException {
        URI id = null;
        URI type = null;
        String issuer = null;
        DateTimeAttribute issueInstant = null;
        AttributeValue value = null;
        HashSet<AttributeValue> valueSet = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (!SunxacmlUtil.getNodeName(root).equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + SunxacmlUtil.getNodeName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
        }
        try {
            Node instantNode;
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
            if ((instantNode = attrs.getNamedItem("IssueInstant")) != null) {
                issueInstant = DateTimeAttribute.getInstance(instantNode.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional AttributeType attribute", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("AttributeValue")) continue;
            try {
                value = attrFactory.createValue(node, type);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", uie);
            }
            if (valueSet == null) {
                valueSet = new HashSet<AttributeValue>();
            }
            valueSet.add(value);
        }
        if (value == null) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(id, type, issuer, issueInstant, valueSet);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public Set<AttributeValue> getValues() {
        return this.attributeValues;
    }

    public AttributeValue getValue() {
        if (this.attributeValues != null) {
            return this.attributeValues.iterator().next();
        }
        return null;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + this.encode());
    }

    public String encode() {
        String encoded = "<Attribute AttributeId=\"" + this.id.toString() + "\" " + "DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            encoded = encoded + " Issuer=\"" + this.issuer + "\"";
        }
        if (this.issueInstant != null) {
            encoded = encoded + " IssueInstant=\"" + this.issueInstant.encode() + "\"";
        }
        encoded = encoded + ">";
        if (this.attributeValues != null) {
            for (AttributeValue value : this.attributeValues) {
                encoded = encoded + value.encodeWithTags(false);
            }
        }
        encoded = encoded + "</Attribute>";
        return encoded;
    }
}

