/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.endpoint.deployers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.endpoint.deployers.EJBIdentifier;
import org.jboss.ejb3.endpoint.deployers.EndpointResolver;
import org.jboss.ejb3.endpoint.deployers.impl.EndpointImpl;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3EndpointDeployer
extends AbstractSimpleRealDeployer<JBossMetaData> {
    private EJBIdentifier identifier;
    private EndpointResolver resolver;

    public EJB3EndpointDeployer() {
        super(JBossMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, JBossMetaData metaData) throws DeploymentException {
        if (!metaData.isEJB3x()) {
            return;
        }
        JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            if (!bean.isSession()) continue;
            this.log.debug((Object)("found bean " + bean));
            this.deploy(unit, (JBossSessionBeanMetaData)bean);
        }
    }

    protected void deploy(DeploymentUnit unit, JBossSessionBeanMetaData beanMetaData) throws DeploymentException {
        String ejbName = beanMetaData.getEjbName();
        String ejbBeanName = this.identifier.identifyEJB(unit, ejbName);
        String name = this.resolver.resolve(unit, ejbName);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)EndpointImpl.class.getName());
        builder.addPropertyMetaData("container", builder.createInject((Object)ejbBeanName));
        BeanMetaData bmd = builder.getBeanMetaData();
        this.log.debug((Object)("Deploy " + bmd));
        unit.addAttachment(BeanMetaData.class + ":" + name, (Object)bmd);
    }

    @Inject
    public void setEJBIdentifier(EJBIdentifier identifier) {
        this.identifier = identifier;
    }

    @Inject
    public void setEndpointResolver(EndpointResolver resolver) {
        this.resolver = resolver;
    }

    public void undeploy(DeploymentUnit unit, JBossMetaData metaData) {
        JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            if (!bean.isSession()) continue;
            this.log.debug((Object)("found bean " + bean));
            this.undeploy(unit, (JBossSessionBeanMetaData)bean);
        }
    }

    protected void undeploy(DeploymentUnit unit, JBossSessionBeanMetaData bean) {
    }
}

