/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.lazy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.lazy.AbstractLazyInitializer;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLazyInitializer
extends AbstractLazyInitializer {
    @Override
    public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces) throws Throwable {
        if (exposeClass) {
            throw new IllegalArgumentException("Cannot expose class via JDK LazyInitializer.");
        }
        if (interfaces == null || interfaces.isEmpty()) {
            throw new IllegalArgumentException("Null interfaces.");
        }
        KernelControllerContext context = this.getKernelControllerContext(kernel, bean);
        BeanMetaData bmd = context.getBeanMetaData();
        KernelConfigurator configurator = kernel.getConfigurator();
        ClassLoader cl = Configurator.getClassLoader(bmd);
        Class<?> beanClass = this.getBeanClass(context, configurator, cl);
        LazyHandler lazyHandler = new LazyHandler(bean, kernel.getBus(), beanClass);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), JDKLazyInitializer.getClasses(configurator, interfaces, cl), (InvocationHandler)lazyHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyHandler
    extends AbstractLazyInitializer.AbstractInvokeHandler
    implements InvocationHandler {
        public LazyHandler(String bean, KernelBus bus, Class<?> proxyClass) {
            super(JDKLazyInitializer.this, bean, bus, proxyClass);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.executeInvoke(proxy, method, args);
        }
    }
}

