/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class CloseTest
extends ChannelTestBase {
    Channel channel;
    Channel channel1;
    Channel channel2;
    Channel c1;
    Channel c2;
    Channel c3;

    public void tearDown() throws Exception {
        Util.close(this.c3, this.c2, this.c1, this.channel2, this.channel1, this.channel);
        super.tearDown();
    }

    protected boolean useBlocking() {
        return false;
    }

    public void testDoubleClose() throws Exception {
        System.out.println("-- creating channel1 --");
        this.channel1 = this.createChannel();
        System.out.println("-- connecting channel1 --");
        this.channel1.connect("testDoubleClose");
        CloseTest.assertTrue((String)"channel open", (boolean)this.channel1.isOpen());
        CloseTest.assertTrue((String)"channel connected", (boolean)this.channel1.isConnected());
        System.out.println("-- closing channel1 --");
        this.channel1.close();
        System.out.println("-- closing channel1 (again) --");
        this.channel1.close();
        CloseTest.assertFalse((String)"channel not connected", (boolean)this.channel1.isConnected());
        System.out.println("-- done, threads are ");
        Util.printThreads();
    }

    public void testCreationAndClose() throws Exception {
        System.out.println("-- creating channel1 --");
        JChannel c = null;
        c = this.createChannel();
        ((Channel)c).connect("testCreationAndClose");
        CloseTest.assertTrue((String)"channel open", (boolean)((Channel)c).isOpen());
        CloseTest.assertTrue((String)"channel connected", (boolean)((Channel)c).isConnected());
        ((Channel)c).close();
        CloseTest.assertFalse((String)"channel not connected", (boolean)((Channel)c).isConnected());
        ((Channel)c).close();
    }

    public void testViewChangeReceptionOnChannelCloseByParticipant() throws Exception {
        this.c1 = this.createChannel("A");
        System.out.println("-- connecting c1");
        this.c1.connect("testViewChangeReceptionOnChannelCloseByParticipant");
        Util.sleep(500L);
        CloseTest.dumpMessages("c1", this.c1);
        Address a1 = this.c1.getLocalAddress();
        this.c2 = this.createChannel("A");
        System.out.println("-- connecting c2");
        this.c2.connect("testViewChangeReceptionOnChannelCloseByParticipant");
        Util.sleep(500L);
        Address a2 = this.c2.getLocalAddress();
        CloseTest.dumpMessages("c2", this.c2);
        System.out.println("-- closing c2");
        this.c2.close();
        Object obj = this.c1.receive(100L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        View v = (View)obj;
        Vector<Address> members = v.getMembers();
        System.out.println("-- first view of c1: " + v);
        CloseTest.assertEquals((int)2, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a1));
        CloseTest.assertTrue((boolean)members.contains(a2));
        obj = this.c1.receive(100L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        v = (View)obj;
        members = v.getMembers();
        System.out.println("-- second view of c1: " + v);
        CloseTest.assertEquals((int)1, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a1));
        CloseTest.assertFalse((boolean)members.contains(a2));
    }

    public void testViewChangeReceptionOnChannelCloseByCoordinator() throws Exception {
        this.c1 = this.createChannel("A");
        this.c1.connect("testViewChangeReceptionOnChannelCloseByCoordinator");
        Util.sleep(500L);
        CloseTest.dumpMessages("c1", this.c1);
        Address a1 = this.c1.getLocalAddress();
        this.c2 = this.createChannel("A");
        this.c2.connect("testViewChangeReceptionOnChannelCloseByCoordinator");
        Util.sleep(500L);
        Address a2 = this.c2.getLocalAddress();
        View v = (View)this.c2.receive(1L);
        Vector<Address> members = v.getMembers();
        CloseTest.assertEquals((int)2, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a2));
        this.c1.close();
        Util.sleep(500L);
        System.out.println("queue of c2 is " + this.c2.dumpQueue());
        CloseTest.assertTrue((String)("found " + this.c2.getNumMessages() + " messages in channel"), (this.c2.getNumMessages() > 0 ? 1 : 0) != 0);
        Object obj = this.c2.receive(0L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        v = (View)obj;
        members = v.getMembers();
        CloseTest.assertEquals((int)1, (int)members.size());
        CloseTest.assertFalse((boolean)members.contains(a1));
        CloseTest.assertTrue((boolean)members.contains(a2));
        CloseTest.assertEquals((int)0, (int)this.c2.getNumMessages());
    }

    private static void dumpMessages(String msg, Channel ch) throws Exception {
        while (ch.getNumMessages() > 0) {
            Object obj = ch.receive(0L);
            if (!(obj instanceof View)) continue;
            System.out.println(msg + ": " + obj);
        }
    }

    public void testConnectDisconnectConnectCloseSequence() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = this.createChannel();
        System.out.println("-- connecting channel to CloseTest1--");
        this.channel.connect("testConnectDisconnectConnectCloseSequence");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- disconnecting channel --");
        this.channel.disconnect();
        System.out.println("-- connecting channel to OtherGroup --");
        this.channel.connect("testConnectDisconnectConnectCloseSequence");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- closing channel --");
        this.channel.close();
        System.out.println("-- done, threads are ");
        Util.printThreads();
    }

    public void testConnectCloseSequenceWith2Members() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = this.createChannel("A");
        System.out.println("-- connecting channel --");
        this.channel.connect("testConnectCloseSequenceWith2Members");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- creating channel1 --");
        this.channel1 = this.createChannel("A");
        System.out.println("-- connecting channel1 --");
        this.channel1.connect("testConnectCloseSequenceWith2Members");
        System.out.println("view is " + this.channel1.getView());
        System.out.println("-- closing channel1 --");
        this.channel1.close();
        Util.sleep(2000L);
        System.out.println("-- closing channel --");
        this.channel.close();
    }

    public void testCreationAndClose2() throws Exception {
        System.out.println("-- creating channel2 --");
        this.channel2 = this.createChannel();
        System.out.println("-- connecting channel2 --");
        this.channel2.connect("testCreationAndClose2");
        System.out.println("-- closing channel --");
        this.channel2.close();
        Util.sleep(2000L);
        Util.printThreads();
    }

    public void testChannelClosedException() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = this.createChannel();
        System.out.println("-- connecting channel --");
        this.channel.connect("testChannelClosedException");
        System.out.println("-- closing channel --");
        this.channel.close();
        Util.sleep(2000L);
        try {
            this.channel.connect("newGroup");
            CloseTest.fail();
        }
        catch (ChannelClosedException ex) {
            CloseTest.assertTrue((boolean)true);
        }
    }

    public void testCreationAndCloseLoop() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = this.createChannel();
        for (int i = 1; i <= 10; ++i) {
            System.out.println("-- connecting channel (attempt #" + i + " ) --");
            this.channel.connect("testCreationAndCloseLoop");
            System.out.println("-- closing channel --");
            this.channel.close();
            System.out.println("-- reopening channel --");
            this.channel.open();
        }
        this.channel.close();
    }

    public void testMultipleConnectsAndDisconnects() throws Exception {
        this.c1 = this.createChannel("A");
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertFalse((boolean)this.c1.isConnected());
        this.c1.connect("testMultipleConnectsAndDisconnects");
        System.out.println("view after c1.connect(): " + this.c1.getView());
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertTrue((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 1);
        this.c2 = this.createChannel("A");
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertFalse((boolean)this.c2.isConnected());
        this.c2.connect("testMultipleConnectsAndDisconnects");
        System.out.println("view after c2.connect(): " + this.c2.getView());
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertTrue((boolean)this.c2.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        this.c2.disconnect();
        System.out.println("view after c2.disconnect(): " + this.c2.getView());
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertFalse((boolean)this.c2.isConnected());
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1, 1);
        this.c2.connect("testMultipleConnectsAndDisconnects");
        System.out.println("view after c2.connect(): " + this.c2.getView());
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertTrue((boolean)this.c2.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        Util.sleep(300L);
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        this.c3 = this.createChannel("A");
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        this.c1.disconnect();
        Util.sleep(1000L);
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertFalse((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 1);
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
        this.c1.connect("testMultipleConnectsAndDisconnects");
        System.out.println("view after c1.connect(): " + this.c1.getView());
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertTrue((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
    }

    private static void assertServiceAndClusterView(Channel ch, int num) {
        View view = ch.getView();
        String msg = "view=" + view;
        CloseTest.assertNotNull((Object)view);
        CloseTest.assertEquals((String)msg, (int)num, (int)view.size());
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{CloseTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

