/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.interceptor.InvocationContext;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;

public class BusinessMethodBeanMethodInterceptor
implements Interceptor {
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{InvocationContext.class};
    private Method method;

    public BusinessMethodBeanMethodInterceptor(Method beanMethodInterceptorMethod) {
        assert (beanMethodInterceptorMethod != null) : "businessMethodInterceptorMethod is null";
        assert (beanMethodInterceptorMethod.getReturnType() == Object.class) : "return type must be Object " + beanMethodInterceptorMethod;
        assert (Arrays.equals(beanMethodInterceptorMethod.getParameterTypes(), PARAMETER_TYPES)) : "wrong parameter signature";
        this.method = beanMethodInterceptorMethod;
    }

    public String getName() {
        return "BusinessMethodBeanMethodInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        InvocationContextInterceptor.InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        try {
            this.method.setAccessible(true);
            Object[] args = new Object[]{ctx};
            return this.method.invoke(ctx.getTarget(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

