/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.util.DocletUtil;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class SecurityTagsHandler
extends EjbTagsHandler {
    protected transient String currentSecurityRoleName;

    public String securityRoleName() throws XDocletException {
        return this.currentSecurityRoleName;
    }

    public void forAllSecurityRoles(String template) throws XDocletException {
        Collection classes = SecurityTagsHandler.getXJavaDoc().getSourceClasses();
        HashSet<String> roleSet = new HashSet<String>();
        for (XClass clazz : classes) {
            SecurityTagsHandler.setCurrentClass((XClass)clazz);
            if (this.hasPermission(SecurityTagsHandler.getCurrentClass().getDoc())) {
                List permissions = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb.permission");
                for (XTag tag : permissions) {
                    String roleName = tag.getAttributeValue("role-name");
                    if (roleName == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
                }
            }
            List methods = SecurityTagsHandler.getCurrentClass().getMethods();
            for (XMethod method : methods) {
                SecurityTagsHandler.setCurrentMethod((XMethod)method);
                if (!this.hasPermission(SecurityTagsHandler.getCurrentMethod().getDoc()) || !InterfaceTagsHandler.isInterfaceMethod(SecurityTagsHandler.getCurrentMethod())) continue;
                List permissions = SecurityTagsHandler.getCurrentMethod().getDoc().getTags("ejb.permission");
                for (XTag tag : permissions) {
                    String role_name = tag.getAttributeValue("role-name");
                    if (role_name == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)role_name, (String)",")));
                }
            }
            List finders = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:finder");
            for (XTag tag : finders) {
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
            List pk = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:pk");
            for (XTag tag : pk) {
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
        }
        for (String this.currentSecurityRoleName : roleSet) {
            this.generate(template);
        }
    }

    private boolean hasPermission(XDoc doc) {
        return doc.hasTag("ejb:permission");
    }
}

