/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.tools.buildmagic.task.ResolveProperties;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class Require
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected String property;
    protected String classname;
    protected String resource;
    protected File file;
    protected Path classpath;
    protected AntClassLoader loader;
    protected StringBuffer message;

    public void setMessage(String text) {
        this.addText(text);
    }

    public void addText(String text) {
        if (this.message == null) {
            this.message = new StringBuffer();
        }
        this.message.append(text);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setClass(String classname) {
        this.classname = classname;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        if (this.property != null && !this.checkProperty(this.property)) {
            this.missingRequired("property", this.property);
        }
        if (this.file != null && !this.checkFile(this.file)) {
            this.missingRequired("file", this.file);
        }
        if (this.classpath != null) {
            this.loader = new AntClassLoader(this.getProject(), this.classpath, false);
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.missingRequired("resource", this.resource);
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.missingRequired("classname", this.classname);
        }
    }

    protected void missingRequired(String type, Object value) throws BuildException {
        StringBuffer buff = new StringBuffer();
        if (this.message == null) {
            buff.append("Missing required ").append(type).append(": ").append(value);
        } else {
            buff.append(ResolveProperties.subst(this.message.toString(), this.getProject().getProperties(), false));
        }
        throw new BuildException(buff.toString());
    }

    protected boolean checkProperty(String property) {
        boolean exists;
        boolean bl = exists = System.getProperty(property, null) != null;
        if (!exists) {
            Project project = this.getProject();
            boolean bl2 = exists = project.getProperty(property) != null;
            if (!exists) {
                exists = project.getUserProperty(property) != null;
            }
        }
        return exists;
    }

    protected boolean checkFile(File file) {
        return file.exists();
    }

    protected boolean checkClass(String classname) {
        try {
            if (this.loader != null) {
                this.loader.loadClass(classname);
            } else {
                ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                if (cl != null) {
                    cl.loadClass(classname);
                } else {
                    Class.forName(classname);
                }
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            this.log.verbose("Class not found: " + classname);
            return false;
        }
        catch (NoClassDefFoundError e) {
            this.log.verbose("Class cound not be loaded: " + classname);
            return false;
        }
    }

    protected boolean checkResource(String resource) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(resource) != null;
        }
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl != null) {
            return cl.getResourceAsStream(resource) != null;
        }
        return ClassLoader.getSystemResourceAsStream(resource) != null;
    }
}

