/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchImpl;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.latch.SharedLatchImpl;

public class LatchSupport {
    private static String DISABLE_JAVA5_LATCHES = "je.disable.java5.latches";
    private static Class JAVA5_LATCH_CLASS = null;
    private static Class JAVA5_SHARED_LATCH_CLASS = null;
    static LatchTable latchTable;

    public static Class getJava5LatchClass() {
        return JAVA5_LATCH_CLASS;
    }

    public static Latch makeLatch(String name, EnvironmentImpl env) {
        if (JAVA5_LATCH_CLASS == null) {
            return new LatchImpl(name, env);
        }
        try {
            Latch ret = (Latch)JAVA5_LATCH_CLASS.newInstance();
            ret.setName(name);
            return ret;
        }
        catch (InstantiationException IE) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        JAVA5_LATCH_CLASS = null;
        return new LatchImpl(name, env);
    }

    public static Latch makeLatch(EnvironmentImpl env) {
        if (JAVA5_LATCH_CLASS == null) {
            return new LatchImpl(env);
        }
        try {
            return (Latch)JAVA5_LATCH_CLASS.newInstance();
        }
        catch (InstantiationException IE) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        JAVA5_LATCH_CLASS = null;
        return new LatchImpl(env);
    }

    public static SharedLatch makeSharedLatch(String name, EnvironmentImpl env) {
        if (JAVA5_SHARED_LATCH_CLASS == null) {
            return new SharedLatchImpl(name, env);
        }
        try {
            SharedLatch ret = (SharedLatch)JAVA5_SHARED_LATCH_CLASS.newInstance();
            ret.setName(name);
            return ret;
        }
        catch (InstantiationException IE) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        JAVA5_SHARED_LATCH_CLASS = null;
        return new SharedLatchImpl(name, env);
    }

    public static int countLatchesHeld() {
        return latchTable.countLatchesHeld();
    }

    public static void dumpLatchesHeld() {
        System.out.println(LatchSupport.latchesHeldToString());
    }

    public static String latchesHeldToString() {
        return latchTable.latchesHeldToString();
    }

    public static void clearNotes() {
        latchTable.clearNotes();
    }

    static {
        try {
            if (System.getProperty(DISABLE_JAVA5_LATCHES) == null) {
                Class.forName("java.util.concurrent.locks.ReentrantLock");
                JAVA5_LATCH_CLASS = Class.forName("com.sleepycat.je.latch.Java5LatchImpl");
            }
        }
        catch (ClassNotFoundException CNFE) {
            // empty catch block
        }
        try {
            if (System.getProperty(DISABLE_JAVA5_LATCHES) == null) {
                Class.forName("java.util.concurrent.locks.ReentrantReadWriteLock");
                JAVA5_SHARED_LATCH_CLASS = Class.forName("com.sleepycat.je.latch.Java5SharedLatchImpl");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        latchTable = new LatchTable("LatchImpl");
    }
}

